/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jpws.data.Options;
import org.jpws.data.PwsFileSocket;
import org.jpws.front.ActionHandler;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.UndoManager;
import org.jpws.front.util.BlinkingLabel;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.DefaultButtonBarListener;
import org.jpws.front.util.EditorTextField;
import org.jpws.front.util.NotesTextArea;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.SpringUtilities;
import org.jpws.front.util.Util;
import org.jpws.pwslib.data.HeaderFieldList;

public class DatabaseDialog
extends ButtonBarDialog {
    public static final int SECURE_BASIC = 0;
    public static final int SECURE_MEDIUM = 1;
    public static final int SECURE_ADVANCED = 2;
    public static final int SECURE_TOPSECRET = 3;
    private static int TEXTFIELDCOLUMNS = 30;
    private static int MAX_NAME_LENGTH = 128;
    private static int MAX_DESCR_LENGTH = 256;
    private PwsFileSocket socket;
    private EditorTextField nameFld;
    private NotesTextArea descrArea;
    private JComboBox secureCombo;
    private BlinkingLabel countTextLabel;
    private JLabel loopsValueLabel;
    private boolean isNewFile;

    public DatabaseDialog(PwsFileSocket pwsFileSocket, String string, boolean bl) throws HeadlessException {
        super(Global.getActiveFrame(), 4, false);
        this.init(pwsFileSocket, string, bl);
    }

    public DatabaseDialog(Dialog dialog, PwsFileSocket pwsFileSocket, String string, boolean bl) throws HeadlessException {
        super(dialog, 4, false);
        this.init(pwsFileSocket, string, bl);
    }

    private void init(PwsFileSocket pwsFileSocket, String string, boolean bl) {
        if (pwsFileSocket == null | string == null) {
            throw new NullPointerException();
        }
        this.isNewFile = bl;
        this.moveRelatedTo(Global.mainFrame);
        this.setTitle(ResourceLoader.codeOrRealDisplay(string));
        this.setButtonBarListener(new BarListener());
        this.setBarGap(8);
        this.socket = pwsFileSocket;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 25, 0, 30));
        JLabel jLabel = new JLabel(ResourceLoader.getDisplay("label.newdb.database"));
        Font font = jLabel.getFont().deriveFont(0);
        this.nameFld = new EditorTextField(TEXTFIELDCOLUMNS);
        ActionHandler.registerTextEditor(this.nameFld);
        jPanel2.add(jLabel);
        jPanel2.add(this.nameFld);
        jLabel = new JLabel(ResourceLoader.getDisplay("label.newdb.description"));
        this.descrArea = new NotesTextArea(5, TEXTFIELDCOLUMNS);
        this.descrArea.setMargin(new Insets(2, 4, 2, 2));
        this.descrArea.getDocument().addDocumentListener(new TextListener());
        ActionHandler.registerTextEditor(this.descrArea);
        JScrollPane jScrollPane = new JScrollPane(this.descrArea);
        jPanel2.add(jLabel);
        jPanel2.add(jScrollPane);
        jLabel = new JLabel(ResourceLoader.getDisplay("label.newdb.securitylevel"));
        jPanel2.add(jLabel);
        String[] stringArray = new String[]{ResourceLoader.getDisplay("choice.newdb.basic"), ResourceLoader.getDisplay("choice.newdb.medium"), ResourceLoader.getDisplay("choice.newdb.advanced"), ResourceLoader.getDisplay("choice.newdb.topsecret")};
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.secureCombo = new JComboBox<String>(stringArray);
        ActionHandler.registerChangeableObject(this.secureCombo);
        this.secureCombo.setFont(this.secureCombo.getFont().deriveFont(14.0f));
        this.secureCombo.addActionListener(new ComboListener());
        jPanel3.add(this.secureCombo);
        jPanel3.add(Box.createHorizontalStrut(10));
        this.loopsValueLabel = new JLabel();
        this.loopsValueLabel.setFont(font);
        jPanel3.add(this.loopsValueLabel);
        jPanel4.add((Component)jPanel3, "Center");
        this.countTextLabel = new BlinkingLabel();
        this.countTextLabel.setFont(font);
        Global.addTimePulseListener(this.countTextLabel);
        jPanel4.add((Component)this.countTextLabel, "East");
        jPanel2.add(jPanel4);
        this.setTextLengthValue(0);
        this.secureCombo.setSelectedIndex(DatabaseDialog.choiceOfLoops(pwsFileSocket.getSecurityLoops()));
        this.nameFld.setText(pwsFileSocket.getHeaderValue(9));
        this.descrArea.setText(pwsFileSocket.getHeaderValue(10));
        SpringUtilities.makeCompactGrid(jPanel2, 3, 2, 0, 0, 10, 8);
        jPanel.add(jPanel2);
        this.setDialogPanel(jPanel2);
    }

    public void show() {
        super.show();
        if (this.isNewFile) {
            Global.setDialogActive("DatabaseDialog.NewFile", true);
        }
    }

    public void dispose() {
        super.dispose();
        Global.removeTimePulseListener(this.countTextLabel);
        if (this.isNewFile) {
            Global.setDialogActive("DatabaseDialog.NewFile", false);
        }
    }

    public String getDatabaseName() {
        String string = this.nameFld.getText();
        if (string.length() > MAX_NAME_LENGTH) {
            string = string.substring(0, MAX_NAME_LENGTH);
        }
        return string;
    }

    public String getDescription() {
        String string = this.descrArea.getText();
        if (string.length() > MAX_DESCR_LENGTH) {
            string = string.substring(0, MAX_DESCR_LENGTH);
        }
        return string;
    }

    public int getSecurityChoice() {
        return Math.max(this.secureCombo.getSelectedIndex(), 0);
    }

    private void setLoopsValue(int n) {
        String string = ResourceLoader.getDisplay("label.newdb.loopsvalue");
        string = Util.substituteText(string, "$value", Util.dottedNumber(n));
        this.loopsValueLabel.setText(string);
    }

    private void setTextLengthValue(int n) {
        boolean bl = n > MAX_DESCR_LENGTH;
        this.countTextLabel.setText(String.valueOf(n));
        this.countTextLabel.setBlinking(bl);
        this.countTextLabel.setForeground(bl ? Color.RED : Color.BLACK);
    }

    public static int loopsOfChoice(int n) {
        int n2;
        int n3 = 2048;
        switch (n) {
            case 1: {
                n2 = n3 * 10;
                break;
            }
            case 2: {
                n2 = n3 * 100;
                break;
            }
            case 3: {
                n2 = n3 * 1000;
                break;
            }
            default: {
                n2 = n3;
            }
        }
        return n2;
    }

    public static int choiceOfLoops(int n) {
        int n2 = 2048;
        int n3 = n <= n2 ? 0 : (n <= n2 * 10 ? 1 : (n <= n2 * 100 ? 2 : 3));
        return n3;
    }

    public class BarListener
    extends DefaultButtonBarListener {
        public boolean okButtonPerformed() {
            HeaderFieldList headerFieldList = DatabaseDialog.this.socket.getHeaderFields();
            int n = DatabaseDialog.this.socket.getSecurityLoops();
            String string = null;
            int n2 = DatabaseDialog.this.nameFld.getText().length();
            if (n2 > MAX_NAME_LENGTH) {
                String string2 = ResourceLoader.getDisplay("label.newdb.database");
                string = ResourceLoader.getDisplay("msg.exceedingvalue.cut");
                string = Util.substituteText(string, "$field", string2);
                string = Util.substituteText(string, "$max", String.valueOf(MAX_NAME_LENGTH));
                string = Util.substituteText(string, "$delta", String.valueOf(n2 - MAX_NAME_LENGTH));
            } else {
                n2 = DatabaseDialog.this.descrArea.getDocument().getLength();
                if (n2 > MAX_DESCR_LENGTH) {
                    String string3 = ResourceLoader.getDisplay("label.newdb.description");
                    string = ResourceLoader.getDisplay("msg.exceedingvalue.cut");
                    string = Util.substituteText(string, "$field", string3);
                    string = Util.substituteText(string, "$max", String.valueOf(MAX_DESCR_LENGTH));
                    string = Util.substituteText(string, "$delta", String.valueOf(n2 - MAX_DESCR_LENGTH));
                }
            }
            if (string == null || GUIService.userConfirm(DatabaseDialog.this, string)) {
                DatabaseDialog.this.socket.setHeaderField(9, DatabaseDialog.this.getDatabaseName());
                DatabaseDialog.this.socket.setHeaderField(10, DatabaseDialog.this.getDescription());
                int n3 = DatabaseDialog.this.getSecurityChoice();
                int n4 = DatabaseDialog.loopsOfChoice(n3);
                DatabaseDialog.this.socket.setSecurityLoops(n4);
                Options.setIntOption("newFileSecurity", n4);
                if (DatabaseDialog.this.socket instanceof PwsFileContainer) {
                    UndoManager.HeaderEdit headerEdit = new UndoManager.HeaderEdit((PwsFileContainer)DatabaseDialog.this.socket, headerFieldList, n);
                    ((PwsFileContainer)DatabaseDialog.this.socket).fireEditEvent(headerEdit);
                }
                DatabaseDialog.this.dispose();
                return true;
            }
            return false;
        }

        public void cancelButtonPerformed() {
            DatabaseDialog.this.dispose();
        }

        public void helpButtonPerformed() {
            GUIService.startHelpDialog(DatabaseDialog.this, "dlg.help.database");
        }
    }

    private class ComboListener
    implements ActionListener {
        private ComboListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DatabaseDialog.this.secureCombo) {
                DatabaseDialog.this.setLoopsValue(DatabaseDialog.loopsOfChoice(DatabaseDialog.this.secureCombo.getSelectedIndex()));
            }
        }
    }

    private class TextListener
    implements DocumentListener {
        private TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DatabaseDialog.this.setTextLengthValue(documentEvent.getDocument().getLength());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DatabaseDialog.this.setTextLengthValue(documentEvent.getDocument().getLength());
        }
    }
}

