/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jpws.data.Exchange;
import org.jpws.data.Options;
import org.jpws.front.FileOpenDialog;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.Service;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.ButtonBarListener;
import org.jpws.front.util.OutputVector;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.pwslib.data.PwsFile;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.persist.ByteArrayOutputStreamPws;

public class ExportCSVDialog
extends ButtonBarDialog
implements ButtonBarListener,
ActionListener {
    private PwsFileContainer container;
    private PwsFile recordList;
    private JComboBox formatCombo;
    private JComboBox charsetCombo;
    private JButton fileButton;
    private JLabel filepathLabel;
    private File outFile;
    private boolean isFileExport;

    public ExportCSVDialog(PwsFileContainer pwsFileContainer) {
        super((Frame)Global.mainFrame, 4, true);
        this.container = pwsFileContainer;
        if (this.container == null) {
            throw new NullPointerException();
        }
        this.isFileExport = true;
        this.recordList = this.container.getPwsFile();
        this.init();
    }

    public ExportCSVDialog(PwsFileContainer pwsFileContainer, DefaultRecordWrapper[] defaultRecordWrapperArray) {
        super((Frame)Global.mainFrame, 4, true);
        if (defaultRecordWrapperArray == null | pwsFileContainer == null) {
            throw new NullPointerException();
        }
        this.isFileExport = false;
        this.container = pwsFileContainer;
        this.recordList = new PwsFile(defaultRecordWrapperArray);
        this.recordList.setFilePath(pwsFileContainer.getFilePath());
        this.recordList.setPassphrase(pwsFileContainer.getPassphrase());
        this.init();
    }

    private void init() {
        String string = this.container.getFileName();
        if (string.equals("?")) {
            string = this.container.getDatabaseName();
        }
        this.outFile = new File(Global.exchangeDir, string + (this.isFileExport ? ".export.csv" : ".exportsel.csv"));
        this.setTitle(ResourceLoader.getDisplay("dlg.export.csv"));
        this.setButtonBarListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setBarGap(2);
        this.filepathLabel = new JLabel(this.outFile.getPath());
        this.filepathLabel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
        this.filepathLabel.setForeground(Color.green);
        this.filepathLabel.setBackground(Color.gray);
        this.filepathLabel.setOpaque(true);
        jPanel.add((Component)this.filepathLabel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel();
        GridLayout gridLayout = new GridLayout(4, 1, 0, 10);
        jPanel3.setLayout(gridLayout);
        JPanel jPanel4 = new JPanel(new GridLayout(4, 1, 0, 10));
        jPanel2.add((Component)jPanel3, "West");
        jPanel2.add((Component)jPanel4, "Center");
        JLabel jLabel = new JLabel(ResourceLoader.getDisplay("label.scope"));
        jPanel3.add(jLabel);
        string = this.isFileExport ? ResourceLoader.getDisplay("label.entirefile") : ResourceLoader.getDisplay("label.recordselection") + " (" + this.recordList.getRecordCount() + ")";
        jLabel = new JLabel(string);
        jPanel4.add(jLabel);
        jLabel = new JLabel(ResourceLoader.getDisplay("label.fileformat"));
        jPanel3.add(jLabel);
        this.formatCombo = new JComboBox<String>(new String[]{ResourceLoader.getDisplay("label.database"), ResourceLoader.getDisplay("label.spreadsheet")});
        int n = Options.getIntOption("export.format");
        if (n < 0 | n > 1) {
            n = 0;
        }
        this.formatCombo.setSelectedIndex(n);
        jPanel4.add(this.formatCombo);
        jLabel = new JLabel(ResourceLoader.getDisplay("label.charset"));
        jPanel3.add(jLabel);
        this.charsetCombo = GUIService.getListedCharsetsCombo();
        string = Options.getOption("export.charset");
        if (string.equals("")) {
            string = Global.getDefaultCharset();
        }
        this.charsetCombo.setSelectedItem(Charset.forName(string));
        jPanel4.add(this.charsetCombo);
        jLabel = new JLabel(ResourceLoader.getDisplay("label.outputfile"));
        jPanel3.add(jLabel);
        this.fileButton = new JButton(ResourceLoader.getDisplay("button.browse"));
        this.fileButton.addActionListener(this);
        jPanel4.add(this.fileButton);
        this.setDialogPanel(jPanel);
    }

    public void dispose() {
        super.dispose();
        this.recordList = null;
        this.fileButton.removeActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileButton) {
            File file;
            FileOpenDialog fileOpenDialog = new FileOpenDialog(8);
            fileOpenDialog.setDialogTitle(ResourceLoader.getDisplay("dlg.export.csv.outputfile"));
            fileOpenDialog.setSelectedFile(this.outFile);
            if (fileOpenDialog.showOpenDialog(this) == 0 && (file = fileOpenDialog.getSelectedFile()) != null) {
                this.outFile = file;
                this.filepathLabel.setText(file.getPath());
            }
            Global.exchangeDir = fileOpenDialog.getCurrentDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelButtonPerformed() {
        PwsFile pwsFile = this.recordList;
        synchronized (pwsFile) {
            this.dispose();
        }
    }

    public void helpButtonPerformed() {
        GUIService.startHelpDialog(this, "dlg.help.csvexport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean okButtonPerformed() {
        FileOutputStream fileOutputStream = null;
        PwsFile pwsFile = this.recordList;
        synchronized (pwsFile) {
            try {
                int n;
                Exchange.FieldSet fieldSet;
                if (this.outFile.exists()) {
                    if (!GUIService.overwriteConfirm((Component)this, this.outFile)) {
                        return false;
                    }
                    Util.wipeAFile(this.outFile);
                }
                fileOutputStream = new FileOutputStream(this.outFile);
                ByteArrayOutputStreamPws byteArrayOutputStreamPws = new ByteArrayOutputStreamPws();
                OutputVector outputVector = new OutputVector();
                outputVector.addStream(fileOutputStream);
                outputVector.addStream(byteArrayOutputStreamPws);
                if (this.formatCombo.getSelectedIndex() == 0) {
                    fieldSet = Exchange.allFields();
                    n = 0;
                } else {
                    fieldSet = Exchange.essentialFields();
                    n = 1;
                }
                Charset charset = (Charset)this.charsetCombo.getSelectedItem();
                if (charset == null) {
                    charset = Charset.forName(Global.getDefaultCharset());
                }
                boolean bl = Service.csvExportRecords(outputVector, this.recordList, fieldSet, null, charset, n);
                outputVector.close();
                Options.setOption("export.charset", charset.name());
                Options.setIntOption("export.format", this.formatCombo.getSelectedIndex());
                if (bl) {
                    String string = ResourceLoader.getDisplay("msg.confirm.export");
                    string = Util.substituteText(string, "$file", this.outFile.getAbsolutePath());
                    GUIService.infoMessage(this, null, string);
                    return true;
                }
            }
            catch (Exception exception) {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                exception.printStackTrace();
                String string = ResourceLoader.getDisplay("msg.export.error");
                GUIService.failureMessage(string, exception);
            }
            return false;
        }
    }

    public boolean extraButtonPerformed(Object object) {
        return true;
    }
}

