/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jpws.data.Options;
import org.jpws.data.PwsFileSocket;
import org.jpws.front.DatabaseDialog;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.DefaultButtonBarListener;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.SpringUtilities;
import org.jpws.front.util.Util;

public class FileInfoDialog
extends ButtonBarDialog
implements ChangeListener {
    private static final Font FIELDFONT = new JTextField().getFont();
    private PwsFileSocket socket;
    private BarListener barListener;
    private JButton clearButton;
    private JButton editButton;
    private JPanel contentPanel;
    private JLabel nameLabel;
    private JLabel descriptLabel;
    private JLabel filenameLabel;
    private JLabel locationLabel;
    private JLabel securityLabel;
    private JLabel uuidLabel;
    private JLabel formatLabel;
    private JLabel recsLabel;
    private JLabel sizeLabel;
    private JLabel saveTimeLabel;
    private JLabel groupsLabel;
    private JLabel signatLabel;
    private JLabel ukfLabel;
    private JLabel ukfSizeLabel;
    private String loopsText;
    private static int foCount = 0;

    public FileInfoDialog(PwsFileSocket pwsFileSocket) throws HeadlessException {
        super(Global.getActiveFrame(), 2, false);
        if (pwsFileSocket == null) {
            throw new NullPointerException();
        }
        this.init(pwsFileSocket);
    }

    private String databaseName() {
        return this.socket.getHeaderValue(9);
    }

    private String databaseDescription() {
        return this.socket.getHeaderValue(10);
    }

    private void init(PwsFileSocket pwsFileSocket) {
        Frame frame = Global.getActiveFrame();
        this.loopsText = ResourceLoader.getDisplay("label.loops");
        this.setTitle(ResourceLoader.getDisplay("dlg.fileinfo"));
        this.setResizable(true);
        this.moveRelatedTo(frame);
        this.socket = pwsFileSocket;
        this.socket.addChangeListener(this);
        this.clearButton = new JButton(ResourceLoader.getDisplay("button.clear.ukf"));
        this.getButtonBar().add((Component)this.clearButton, 0);
        this.editButton = new JButton(ResourceLoader.getDisplay("button.modify"));
        if (this.socket.getFileFormat() >= 3) {
            this.getButtonBar().add((Component)this.editButton, 0);
        }
        this.barListener = new BarListener();
        this.setButtonBarListener(this.barListener);
        this.buildCenterPanel();
        this.setupContent();
        this.setDialogPanel(this.contentPanel);
        Point point = frame.getLocationOnScreen();
        point.x += frame.getWidth();
        Util.setCorrectedLocation(this, point);
        this.setVisible(true);
    }

    public void dispose() {
        super.dispose();
        if (this.socket != null) {
            this.socket.removeChangeListener(this);
            if (this.socket instanceof PwsFileContainer) {
                ((PwsFileContainer)this.socket).fileInfoDlg = null;
            }
        }
    }

    private void buildCenterPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel(new SpringLayout());
            this.contentPanel.setBorder(BorderFactory.createEmptyBorder(6, 8, 0, 8));
        } else {
            this.contentPanel.removeAll();
        }
        JPanel jPanel = this.contentPanel;
        int n = 10;
        this.nameLabel = null;
        if (this.databaseName() != null) {
            this.nameLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.dbname"));
            ++n;
        }
        this.descriptLabel = null;
        if (this.databaseDescription() != null) {
            this.descriptLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.dbdescript"));
            ++n;
        }
        this.filenameLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.filename"));
        this.locationLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.location"));
        this.saveTimeLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.savetime"));
        this.formatLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.format"));
        this.securityLabel = null;
        if (this.socket.getFileFormat() >= 3) {
            this.securityLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.security"));
            ++n;
        }
        this.uuidLabel = null;
        if (this.socket.getFileFormat() >= 3) {
            this.uuidLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.uuid"));
            ++n;
        }
        this.signatLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.sig"));
        this.sizeLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.filesize"));
        this.recsLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.records"));
        this.groupsLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.groups"));
        this.ukfLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.ukf"));
        this.ukfSizeLabel = this.addField(jPanel, ResourceLoader.getDisplay("dlg.fileinfo.ukfsize"));
        SpringUtilities.makeCompactGrid(jPanel, n, 2, 0, 0, 10, 4);
    }

    private JLabel addField(JPanel jPanel, String string) {
        JLabel jLabel = new JLabel(string);
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(FIELDFONT);
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        return jLabel2;
    }

    private String htmlDescription() {
        String string = Util.htmlEncoded(this.databaseDescription());
        String string2 = "<html>" + string;
        JLabel jLabel = new JLabel(string2);
        if (jLabel.getPreferredSize().width > 400) {
            string2 = "<html><table cellspacing=\"0\" cellpadding=\"0\" width=\"350\"><tr><td>" + string + "</td></tr></table>";
            jLabel.setText(string2);
        }
        return string2;
    }

    private void setupContent() {
        long l;
        if (this.nameLabel != null) {
            this.nameLabel.setText(this.databaseName());
        }
        if (this.descriptLabel != null) {
            this.descriptLabel.setText(this.htmlDescription());
        }
        this.filenameLabel.setText(this.socket.getFileName());
        String string = Util.pathNameOfPath(this.socket.getFilePath());
        if (string.length() > 60) {
            string = string.substring(string.length() - 60);
        }
        this.locationLabel.setText(string);
        if (this.uuidLabel != null) {
            this.uuidLabel.setText(this.socket.getUUID().toString());
        }
        this.saveTimeLabel.setText((l = this.socket.getStoreTime()) == 0L ? "?" : new Date(l).toLocaleString());
        this.formatLabel.setText("Password Safe V" + String.valueOf(this.socket.getFileFormat()));
        this.recsLabel.setText(String.valueOf(this.socket.getRecordCount()));
        this.groupsLabel.setText(String.valueOf(this.socket.getGroupCount()));
        string = Util.dottedNumber(this.socket.getStoredSize());
        this.sizeLabel.setText(String.valueOf(string));
        byte[] byArray = this.socket.getSignature();
        this.signatLabel.setText(Util.bytesToHex(byArray, 0, 8));
        if (this.securityLabel != null) {
            this.securityLabel.setText(String.valueOf(this.socket.getSecurityLoops()) + " " + this.loopsText);
        }
        int n = this.socket.getUKFCount();
        this.ukfLabel.setText(String.valueOf(n));
        this.ukfSizeLabel.setText(String.valueOf(this.socket.getUKFSize()));
        this.clearButton.setEnabled(n > 0);
    }

    private boolean mustReformat() {
        boolean bl = this.socket.getFileFormat() < 3;
        return this.nameLabel == null != (this.databaseName() == null) || this.descriptLabel == null != (this.databaseDescription() == null) || this.securityLabel == null != bl || this.uuidLabel == null != bl;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        int n2 = ((PwsFileSocket.ChangeEvent)changeEvent).getState();
        if (n2 == 6) {
            if (this.mustReformat()) {
                System.out.println("** reformatting File-Info " + foCount++);
                this.buildCenterPanel();
                this.setupContent();
                if (this.socket.getFileFormat() >= 3) {
                    this.getButtonBar().add((Component)this.editButton, 0);
                } else {
                    this.getButtonBar().remove(this.editButton);
                }
                this.pack();
            } else {
                this.setupContent();
            }
        } else if (n2 == 3 && (n = ((PwsFileContainer)this.socket).getViewType()) == 0) {
            String string = Util.standardTimeString(System.currentTimeMillis()).substring(11, 16);
            String string2 = ResourceLoader.getDisplay("dlg.fileinfo.closed");
            this.setTitle(Util.substituteText(string2, "$time", string));
            this.contentPanel.setBackground(Color.lightGray);
            this.getButtonBar().setBackground(Color.lightGray);
            this.clearButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.socket.removeChangeListener(this);
            this.socket = null;
        }
    }

    private class BarListener
    extends DefaultButtonBarListener {
        private BarListener() {
        }

        public boolean extraButtonPerformed(Object object) {
            if (object == FileInfoDialog.this.clearButton && GUIService.userConfirm(FileInfoDialog.this, ResourceLoader.getDisplay("dlg.fileinfo.askdelete.ukf"))) {
                FileInfoDialog.this.socket.clearUnknownFields();
                return FileInfoDialog.this.socket.getUKFCount() > 0;
            }
            if (object == FileInfoDialog.this.editButton) {
                DatabaseDialog databaseDialog = new DatabaseDialog(FileInfoDialog.this, FileInfoDialog.this.socket, "dlg.database.edit", false){

                    public void dispose() {
                        if (Options.isOptionSet("rememberScreen")) {
                            this.storeBounds(Options.getOptions(), "fileinfo_editor", true);
                        }
                        super.dispose();
                    }
                };
                if (Options.isOptionSet("rememberScreen")) {
                    databaseDialog.gainBounds(Options.getOptions(), "fileinfo_editor", true);
                }
                databaseDialog.setModal(true);
                ((ButtonBarDialog)databaseDialog).show();
            }
            return true;
        }

        public boolean okButtonPerformed() {
            FileInfoDialog.this.dispose();
            return true;
        }
    }
}

