/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jpws.data.Options;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.util.AutomoveDialog;
import org.jpws.front.util.DialogButtonBar;
import org.jpws.front.util.RecentList;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.front.util.VerticalFlowLayout;

public class FindTextDialog
extends AutomoveDialog
implements ActionListener {
    private static int index = -1;
    private static int winCounter;
    private JPanel dlgPanel;
    private DialogButtonBar buttonBar;
    private JCheckBox checkCase;
    private JCheckBox checkWord;
    private JButton findButton;
    private JComboBox findCombo;
    private RecentList recentFinds;

    public FindTextDialog() throws HeadlessException {
        this.init();
    }

    public FindTextDialog(Dialog dialog) throws HeadlessException {
        super(dialog);
        this.init();
    }

    public FindTextDialog(Frame frame) throws HeadlessException {
        super(frame);
        this.init();
    }

    private void init() {
        this.setTitle(ResourceLoader.getDisplay("dlg.findtext"));
        this.setDefaultCloseOperation(2);
        this.recentFinds = (RecentList)Global.getSelectedFile().getRecentFinds().clone();
        this.buttonBar = new DialogButtonBar(2);
        this.getContentPane().add((Component)this.buttonBar, "South");
        VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout(6);
        verticalFlowLayout.setHorizontalFill(true);
        this.dlgPanel = new JPanel(verticalFlowLayout);
        this.dlgPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 0, 7));
        this.getContentPane().add((Component)this.dlgPanel, "Center");
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        JLabel jLabel = new JLabel(ResourceLoader.getDisplay("find.text"));
        jPanel.add((Component)jLabel, "West");
        this.findCombo = new JComboBox(this.recentFinds);
        this.findCombo.setPreferredSize(new Dimension(150, 20));
        this.findCombo.setEditable(true);
        jPanel.add((Component)this.findCombo, "Center");
        this.dlgPanel.add(jPanel);
        int n = Options.getIntOption("findTextOpt");
        this.checkCase = new JCheckBox(ResourceLoader.getDisplay("find.checkCS"), (n & 1) > 0);
        this.dlgPanel.add(this.checkCase);
        this.checkWord = new JCheckBox(ResourceLoader.getDisplay("find.checkWD"), (n & 2) > 0);
        this.dlgPanel.add(this.checkWord);
        this.findButton = new JButton(ResourceLoader.getDisplay("button.find"));
        this.findButton.addActionListener(this);
        this.dlgPanel.add(this.findButton);
        this.getRootPane().setDefaultButton(this.findButton);
        this.pack();
        Point point = Global.mainFrame.getLocationOnScreen();
        point.x -= this.getWidth();
        if (winCounter == 1) {
            point.y += this.getHeight();
        }
        if (winCounter == 2) {
            point.y += this.getHeight() * 2;
        }
        if (winCounter > 2) {
            point.translate(winCounter * 5, winCounter * 5);
        }
        Util.setCorrectedLocation(this, point);
        ++winCounter;
        this.setVisible(true);
    }

    public void dispose() {
        super.dispose();
        this.findButton.removeActionListener(this);
        this.buttonBar.destruct();
        --winCounter;
        int n = this.checkCase.isSelected() ? 1 : 0;
        Options.setIntOption("findTextOpt", n += this.checkWord.isSelected() ? 2 : 0);
    }

    public static void resetIndex() {
        index = -1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        PwsFileContainer pwsFileContainer = Global.getSelectedFile();
        if (pwsFileContainer == null) {
            this.dispose();
            return;
        }
        String string2 = (String)this.findCombo.getSelectedItem();
        if (string2.equals("")) {
            return;
        }
        boolean bl = index > -1;
        if ((index = pwsFileContainer.findMatching(index, string2, this.checkCase.isSelected(), this.checkWord.isSelected())) > -1) {
            pwsFileContainer.getViewHandler().setSelectedIndex(index);
            pwsFileContainer.getViewHandler().scrollToVisible(index);
            string = ResourceLoader.getDisplay("msg.confirm.textfind") + " : " + pwsFileContainer.getSelectedRecord().getTitle();
        } else {
            string = ResourceLoader.getDisplay(bl ? "msg.endofdocument" : "msg.failtextfind");
            GUIService.infoMessage(this, null, string);
        }
        this.recentFinds.setContent(pwsFileContainer.getRecentFinds().getStringContent());
        Global.setStatusText(string);
        string = index == -1 ? "button.find" : "button.findnext";
        this.findButton.setText(ResourceLoader.getDisplay(string));
    }
}

