/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.jpws.data.Options;
import org.jpws.front.ActionHandler;
import org.jpws.front.ContainerView;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.util.ResourceLoader;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.order.OrderedListEvent;
import org.jpws.pwslib.order.OrderedListListener;
import org.jpws.pwslib.order.OrderedRecordList;

public class TableHandler
implements ContainerView,
OrderedListListener,
ListSelectionListener {
    public static final Color EXPIRED_COLOR = new Color(0xB22222);
    public static final Color EXPIRESOON_COLOR = new Color(13468991);
    public static final Color IMPORTED_COLOR = new Color(16108800);
    public static final Color IMPORTSELECTED_COLOR = Color.GRAY;
    public static final Color CONFLICT_COLOR = new Color(4286945);
    public static final Color CONFLICTSELECTED_COLOR = new Color(1644912);
    public static final Color LIGHTRED_COLOR = new Color(16737095);
    private static Font boldFont;
    private PwsFileContainer owner;
    private PwsTableModel tableModel;
    private JTable table;
    private boolean useColors;

    public TableHandler(PwsFileContainer pwsFileContainer) {
        this.init(pwsFileContainer);
    }

    private void init(PwsFileContainer pwsFileContainer) {
        this.owner = pwsFileContainer;
        pwsFileContainer.getOrderedList().addOrderedListListener(this);
        this.tableModel = new PwsTableModel(pwsFileContainer.getOrderedList());
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.addMouseListener(pwsFileContainer.getMouseAdapter());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setDefaultRenderer("".getClass(), new PwsCellRenderer());
        this.useColors = Options.isOptionSet("useTableColors");
    }

    public void destruct() {
        this.owner = null;
        this.table = null;
        this.tableModel = null;
    }

    public int getFirstSelected() {
        return this.table.getSelectedRow();
    }

    public int[] getSelectedItems() {
        return this.table.getSelectedRows();
    }

    public boolean hasUserSelection() {
        return this.table.getSelectedRow() != -1;
    }

    public void setSelectAll() {
        int n = this.owner.getOrderedList().size();
        if (n > 0) {
            this.table.addRowSelectionInterval(0, n - 1);
        }
    }

    public void setSelectedIndex(int n) {
        int[] nArray = null;
        if (n > -1) {
            nArray = new int[]{n};
        }
        this.setSelectedItems(nArray);
    }

    public void setSelectedItems(int[] nArray) {
        this.table.clearSelection();
        if (nArray != null && nArray.length > 0) {
            int n = Integer.MAX_VALUE;
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n2 <= -1 || n2 >= this.tableModel.getRowCount()) continue;
                this.table.addRowSelectionInterval(n2, n2);
                if (n2 >= n) continue;
                n = n2;
            }
            this.scrollToVisible(n);
        }
    }

    public DefaultRecordWrapper[] getSelectedWrappers() {
        int[] nArray = this.getSelectedItems();
        DefaultRecordWrapper[] defaultRecordWrapperArray = new DefaultRecordWrapper[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            defaultRecordWrapperArray[i] = this.tableModel.getRecord(nArray[i]);
        }
        return defaultRecordWrapperArray;
    }

    public void setSelectedWrappers(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        int n = defaultRecordWrapperArray == null ? 0 : defaultRecordWrapperArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.tableModel.getIndexOf(defaultRecordWrapperArray[i]);
        }
        this.setSelectedItems(nArray);
    }

    public Component getView() {
        return this.table;
    }

    public void updateUI() {
        this.table.updateUI();
    }

    public void scrollToVisible(int n) {
        if (n > -1 & n < this.table.getRowCount()) {
            this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
        }
    }

    public void orderedListPerformed(final OrderedListEvent orderedListEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                TableHandler.this.table.updateUI();
                int n = orderedListEvent.getType();
                if (n == 4) {
                    TableHandler.this.scrollToVisible(TableHandler.this.getFirstSelected());
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.owner.reportPropertyChange(2);
        ActionHandler.resetIdleTime();
    }

    public void reconstruct() {
        this.init(this.owner);
    }

    public void repaint() {
        this.useColors = Options.isOptionSet("useTableColors");
        this.table.repaint();
    }

    public void setFont(Font font) {
        this.table.setFont(font);
        boldFont = null;
    }

    public void setDeleteKeyEnabled(boolean bl) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        if (bl) {
            this.table.getInputMap().put(keyStroke, "DELETE_RECS");
            this.table.getActionMap().put("DELETE_RECS", ActionHandler.getAction("DELETE"));
        } else {
            this.table.getInputMap().put(keyStroke, "DONOTHING");
        }
    }

    private class PwsCellRenderer
    extends DefaultTableCellRenderer {
        private Color defaultForeground;
        private Color defaultSelectionForeground;
        private boolean darkSelectionBackground;

        private PwsCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            DefaultRecordWrapper defaultRecordWrapper;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (TableHandler.this.tableModel == null || (defaultRecordWrapper = TableHandler.this.tableModel.getRecord(n)) == null) {
                return null;
            }
            int n3 = defaultRecordWrapper.getExpiry();
            int n4 = defaultRecordWrapper.getImportStatus();
            Color color2 = color = bl ? this.defaultSelectionForeground : this.defaultForeground;
            if (TableHandler.this.useColors && n3 > 0 | n4 > 0) {
                if (n4 == 1) {
                    color = bl & !this.darkSelectionBackground ? IMPORTSELECTED_COLOR : IMPORTED_COLOR;
                } else if (n4 == 2) {
                    color = bl & !this.darkSelectionBackground ? CONFLICTSELECTED_COLOR : CONFLICT_COLOR;
                } else if (n3 == 1) {
                    color = bl & this.darkSelectionBackground ? LIGHTRED_COLOR : EXPIRED_COLOR;
                } else if (n3 == 2) {
                    color = EXPIRESOON_COLOR;
                }
                if (boldFont == null) {
                    Font font;
                    boldFont = font.deriveFont(1 + ((font = this.getFont()).isItalic() ? 2 : 0));
                }
                this.setFont(boldFont);
            }
            this.setForeground(color);
            return this;
        }

        public void updateUI() {
            super.updateUI();
            this.defaultForeground = UIManager.getColor("Table.foreground");
            this.defaultSelectionForeground = UIManager.getColor("Table.selectionForeground");
            Color color = UIManager.getColor("Table.selectionBackground");
            this.darkSelectionBackground = color.getRed() < 160 & color.getGreen() < 160 & color.getBlue() < 160;
        }
    }

    private class PwsTableModel
    extends AbstractTableModel {
        OrderedRecordList recList;

        public PwsTableModel(OrderedRecordList orderedRecordList) {
            this.recList = orderedRecordList;
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.recList.size();
        }

        public DefaultRecordWrapper getRecord(int n) {
            return this.recList.getItemAt(n);
        }

        public int getIndexOf(DefaultRecordWrapper defaultRecordWrapper) {
            return this.recList.indexOf(defaultRecordWrapper);
        }

        public Object getValueAt(int n, int n2) {
            DefaultRecordWrapper defaultRecordWrapper = this.getRecord(n);
            if (defaultRecordWrapper == null) {
                return "";
            }
            PwsRecord pwsRecord = defaultRecordWrapper.getRecord();
            String string = null;
            switch (n2) {
                case 0: {
                    string = pwsRecord.getGroup();
                    break;
                }
                case 1: {
                    string = pwsRecord.getTitle();
                    break;
                }
                case 2: {
                    string = pwsRecord.getUsername();
                }
            }
            return string == null ? "" : string;
        }

        public String getColumnName(int n) {
            String string = "";
            switch (n) {
                case 0: {
                    string = ResourceLoader.getDisplay("table.group");
                    break;
                }
                case 1: {
                    string = ResourceLoader.getDisplay("table.title");
                    break;
                }
                case 2: {
                    string = ResourceLoader.getDisplay("table.username");
                }
            }
            return string;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

