/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.io.File;
import java.net.URL;
import java.util.Date;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jpws.data.Options;
import org.jpws.data.PwsFileSocket;
import org.jpws.front.ActionHandler;
import org.jpws.front.ContainerView;
import org.jpws.front.GUIService;
import org.jpws.front.MenuHandler;
import org.jpws.front.PwsFileContainer;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.pwslib.data.HeaderFieldList;
import org.jpws.pwslib.data.PwsFile;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.data.PwsRecordList;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.persist.ApplicationAdapter;

public class UndoManager
extends javax.swing.undo.UndoManager {
    public UndoManager() {
        int n = Options.getIntOption("maxUndoEntries");
        int n2 = n > 0 ? n : 25;
        this.setLimit(n2);
    }

    public void clear() {
        this.discardAllEdits();
        MenuHandler.undoUpdated();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (Options.isOptionSet("useUndoRedo")) {
            super.undoableEditHappened(undoableEditEvent);
            MenuHandler.undoUpdated();
        }
    }

    public static class HeaderEdit
    extends AbstractUndoableEdit {
        private PwsFileSocket file;
        private HeaderFieldList oldList;
        private HeaderFieldList newList;
        private int oldLoops;
        private int newLoops;

        public HeaderEdit(PwsFileSocket pwsFileSocket, HeaderFieldList headerFieldList) {
            if (pwsFileSocket == null | headerFieldList == null) {
                throw new NullPointerException();
            }
            this.file = pwsFileSocket;
            this.oldList = (HeaderFieldList)headerFieldList.clone();
            this.newList = pwsFileSocket.getHeaderFields();
        }

        public HeaderEdit(PwsFileSocket pwsFileSocket, HeaderFieldList headerFieldList, int n) {
            if (pwsFileSocket == null) {
                throw new NullPointerException();
            }
            this.file = pwsFileSocket;
            if (headerFieldList != null) {
                this.oldList = (HeaderFieldList)headerFieldList.clone();
                this.newList = pwsFileSocket.getHeaderFields();
            }
            if (n > 0) {
                this.oldLoops = n;
                this.newLoops = pwsFileSocket.getSecurityLoops();
            }
        }

        public String getPresentationName() {
            return ResourceLoader.getDisplay("undo.headeredit");
        }

        public void die() {
            super.die();
            Log.debug(5, "-- die UndoableEdit: " + this.toString());
            this.newList = null;
            this.oldList = null;
        }

        public String toString() {
            return this.getPresentationName() + " *** " + super.toString();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                if (this.newList != null) {
                    this.file.setHeaderFields(this.newList);
                }
                if (this.newLoops > 0) {
                    this.file.setSecurityLoops(this.newLoops);
                }
                MenuHandler.undoUpdated();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new CannotUndoException();
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                if (this.oldList != null) {
                    this.file.setHeaderFields(this.oldList);
                }
                if (this.oldLoops > 0) {
                    this.file.setSecurityLoops(this.oldLoops);
                }
                MenuHandler.undoUpdated();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GUIService.failureMessage("UNDO failure!", exception);
                throw new CannotUndoException();
            }
        }
    }

    public static class ModifyPasswordEdit
    extends AbstractUndoableEdit {
        private PwsFileSocket file;
        private PwsPassphrase oldPass;
        private PwsPassphrase newPass;
        private long updateTime;

        public ModifyPasswordEdit(PwsFileSocket pwsFileSocket, PwsPassphrase pwsPassphrase, PwsPassphrase pwsPassphrase2) {
            if (pwsFileSocket == null | pwsPassphrase2 == null) {
                throw new NullPointerException();
            }
            this.file = pwsFileSocket;
            this.oldPass = pwsPassphrase;
            this.newPass = pwsPassphrase2;
            this.updateTime = System.currentTimeMillis();
        }

        public long getUpdateTime() {
            return this.updateTime;
        }

        public void die() {
            super.die();
            Log.debug(5, "-- die UndoableEdit " + this.toString());
            this.oldPass = null;
            this.newPass = null;
            this.file = null;
        }

        public String toString() {
            return this.getPresentationName() + " *** " + super.toString();
        }

        public String getPresentationName() {
            return ResourceLoader.getDisplay("undo.modify.passphrase");
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.file.setPassphrase(this.newPass);
            MenuHandler.undoUpdated();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.file.setPassphrase(this.oldPass);
            MenuHandler.undoUpdated();
        }
    }

    public static class FileEdit
    extends AbstractUndoableEdit {
        public static final int REVERT_EDIT = 0;
        public static final int RESTORE_EDIT = 1;
        private int type;
        private PwsFileSocket file;
        private PwsFile oldFile;
        private ApplicationAdapter adapter;
        private String externalPath;
        private String externalName;
        private long time;

        public FileEdit(int n, PwsFileSocket pwsFileSocket, PwsFile pwsFile, long l) {
            this.init(n, pwsFileSocket, pwsFile.getApplication(), pwsFile.getFilePath(), l);
        }

        private void init(int n, PwsFileSocket pwsFileSocket, ApplicationAdapter applicationAdapter, String string, long l) {
            if (n < 0 | n > 3) {
                throw new IllegalArgumentException("undefined edit type");
            }
            if (pwsFileSocket == null) {
                throw new NullPointerException("file socket void");
            }
            if (applicationAdapter == null) {
                throw new NullPointerException("external io-context parameter void");
            }
            if (string == null || string.length() == 0) {
                throw new NullPointerException("external file parameter void");
            }
            this.type = n;
            this.file = pwsFileSocket;
            this.adapter = applicationAdapter;
            this.externalPath = string;
            this.externalName = new File(string).getName();
            this.time = l;
            if (n == 1 | n == 0) {
                this.oldFile = (PwsFile)pwsFileSocket.getPwsFile().copy();
            }
        }

        public String getPresentationName() {
            String string;
            switch (this.type) {
                case 0: {
                    String string2 = this.time == 0L ? "" : new Date(this.time).toLocaleString();
                    string = ResourceLoader.getDisplay("undo.revert.file") + " \"" + string2 + "\"";
                    break;
                }
                case 1: {
                    string = ResourceLoader.getDisplay("undo.restore.file") + " \"" + this.externalName + "\"";
                    break;
                }
                default: {
                    string = "??";
                }
            }
            return string;
        }

        public void die() {
            super.die();
            Log.debug(5, "-- die UndoableEdit: " + this.toString());
        }

        public String toString() {
            return this.getPresentationName() + " *** " + super.toString();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                switch (this.type) {
                    case 0: 
                    case 1: {
                        URL uRL = Util.makeFileURL(this.externalPath);
                        PwsFile pwsFile = ActionHandler.passTryOpen(uRL, this.file.getPassphrase());
                        if (pwsFile == null) break;
                        this.file.substituteContent(pwsFile);
                        String string = this.type == 0 ? "msg.confirm.revert" : "<html>" + ResourceLoader.getDisplay("msg.confirm.restore") + "<br><font color=\"green\">" + pwsFile.getFilePath();
                        GUIService.infoMessage(null, string);
                        break;
                    }
                }
                MenuHandler.undoUpdated();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new CannotUndoException();
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                switch (this.type) {
                    case 0: 
                    case 1: {
                        this.file.substituteContent(this.oldFile);
                        String string = this.type == 0 ? "msg.undo.confirm.revertundo" : "msg.undo.confirm.restoreundo";
                        GUIService.infoMessage(null, string);
                        break;
                    }
                }
                MenuHandler.undoUpdated();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                GUIService.failureMessage("UNDO failure!", exception);
                throw new CannotUndoException();
            }
        }
    }

    public static class ModifyRecordEdit
    extends AbstractUndoableEdit {
        public static final int MODIFY_RECORD_EDIT = 0;
        public static final int NEW_RECORD_EDIT = 1;
        public static final int MOVE_RECORD_EDIT = 2;
        public static final int MOVE_GROUP_EDIT = 5;
        public static final int DUPLICATE_RECORD_EDIT = 3;
        public static final int DUPLICATE_GROUP_EDIT = 6;
        public static final int RENAME_GROUP_EDIT = 4;
        public static final int IMPORT_RECORDS_EDIT = 7;
        private int type;
        private PwsFileSocket file;
        private DefaultRecordWrapper[] oldRecs;
        private DefaultRecordWrapper[] newRecs;
        private DefaultRecordWrapper[] copyRecs;
        private String oldgroup;
        private String newgroup;
        private boolean single;

        public ModifyRecordEdit(int n, PwsFileSocket pwsFileSocket, DefaultRecordWrapper[] defaultRecordWrapperArray, DefaultRecordWrapper[] defaultRecordWrapperArray2, String string, String string2) {
            this.init(n, pwsFileSocket, defaultRecordWrapperArray, defaultRecordWrapperArray2, null, string, string2);
        }

        public ModifyRecordEdit(int n, PwsFileSocket pwsFileSocket, DefaultRecordWrapper[] defaultRecordWrapperArray, DefaultRecordWrapper[] defaultRecordWrapperArray2, DefaultRecordWrapper[] defaultRecordWrapperArray3, String string) {
            this.init(n, pwsFileSocket, defaultRecordWrapperArray, defaultRecordWrapperArray2, defaultRecordWrapperArray3, null, string);
        }

        public ModifyRecordEdit(int n, PwsFileSocket pwsFileSocket, DefaultRecordWrapper[] defaultRecordWrapperArray, DefaultRecordWrapper[] defaultRecordWrapperArray2) {
            this.init(n, pwsFileSocket, defaultRecordWrapperArray, defaultRecordWrapperArray2, null, null, null);
        }

        public ModifyRecordEdit(int n, PwsFileSocket pwsFileSocket, PwsRecord pwsRecord, PwsRecord pwsRecord2) {
            DefaultRecordWrapper[] defaultRecordWrapperArray = new DefaultRecordWrapper[]{new DefaultRecordWrapper(pwsRecord2, null)};
            DefaultRecordWrapper[] defaultRecordWrapperArray2 = pwsRecord != null ? new DefaultRecordWrapper[]{new DefaultRecordWrapper(pwsRecord, null)} : null;
            this.init(n, pwsFileSocket, defaultRecordWrapperArray2, defaultRecordWrapperArray, null, null, null);
        }

        private void init(int n, PwsFileSocket pwsFileSocket, DefaultRecordWrapper[] defaultRecordWrapperArray, DefaultRecordWrapper[] defaultRecordWrapperArray2, DefaultRecordWrapper[] defaultRecordWrapperArray3, String string, String string2) {
            int n2;
            if (n < 0 | n > 7) {
                throw new IllegalArgumentException("undefined edit type");
            }
            if (pwsFileSocket == null) {
                throw new NullPointerException("file socket void");
            }
            if (defaultRecordWrapperArray2 == null) {
                throw new NullPointerException("new state records void");
            }
            if (defaultRecordWrapperArray2.length == 0) {
                throw new IllegalArgumentException("empty new state record list");
            }
            if (n != 1 & n != 3 & n != 6 & n != 7 & defaultRecordWrapperArray == null) {
                throw new NullPointerException("old state records void");
            }
            if (n == 4 & (string == null | string2 == null)) {
                throw new NullPointerException("group name void");
            }
            this.type = n;
            this.file = pwsFileSocket;
            this.oldgroup = string;
            this.newgroup = string2;
            this.single = defaultRecordWrapperArray2.length == 1;
            this.newRecs = new DefaultRecordWrapper[defaultRecordWrapperArray2.length];
            for (n2 = 0; n2 < defaultRecordWrapperArray2.length; ++n2) {
                this.newRecs[n2] = (DefaultRecordWrapper)defaultRecordWrapperArray2[n2].clone();
            }
            if (defaultRecordWrapperArray != null) {
                this.oldRecs = new DefaultRecordWrapper[defaultRecordWrapperArray.length];
                for (n2 = 0; n2 < defaultRecordWrapperArray.length; ++n2) {
                    this.oldRecs[n2] = (DefaultRecordWrapper)defaultRecordWrapperArray[n2].clone();
                }
            }
            if (defaultRecordWrapperArray3 != null) {
                this.copyRecs = new DefaultRecordWrapper[defaultRecordWrapperArray3.length];
                for (n2 = 0; n2 < defaultRecordWrapperArray3.length; ++n2) {
                    this.copyRecs[n2] = (DefaultRecordWrapper)defaultRecordWrapperArray3[n2].clone();
                }
            }
        }

        public void die() {
            super.die();
            Log.debug(5, "-- die UndoableEdit " + this.toString());
            this.newRecs = null;
            this.oldRecs = null;
            this.file = null;
        }

        public String toString() {
            return this.getPresentationName() + " *** " + super.toString();
        }

        private String recordTitle() {
            return this.newRecs.length == 1 ? " \"" + this.newRecs[0].toString() + " \"" : "";
        }

        private String groupTitle() {
            String string = "?";
            int n = 0;
            if (this.oldgroup != null) {
                string = this.oldgroup;
            } else if (this.newgroup != null) {
                string = this.newgroup;
            }
            if (this.oldRecs != null) {
                n = this.oldRecs.length;
            } else if (this.newRecs != null) {
                n = this.newRecs.length;
            }
            return " \"" + string + "\" " + (n != 0 ? "(" + n + ")" : "");
        }

        public String getPresentationName() {
            String string;
            switch (this.type) {
                case 0: {
                    string = ResourceLoader.getDisplay("undo.modify.record") + this.recordTitle();
                    break;
                }
                case 1: {
                    string = ResourceLoader.getDisplay("undo.new.record") + this.recordTitle();
                    break;
                }
                case 2: {
                    if (this.single) {
                        string = ResourceLoader.getDisplay("undo.move.record") + this.recordTitle();
                        break;
                    }
                    String string2 = ResourceLoader.getDisplay("undo.move.records");
                    string2 = Util.substituteText(string2, "$amount", String.valueOf(this.newRecs.length));
                    string = Util.substituteText(string2, "$target", this.newgroup);
                    break;
                }
                case 5: {
                    string = ResourceLoader.getDisplay("undo.move.group") + this.groupTitle();
                    break;
                }
                case 3: {
                    string = this.single ? ResourceLoader.getDisplay("undo.duplicate.record") + this.recordTitle() : ResourceLoader.getDisplay("undo.duplicate.records") + " (" + this.newRecs.length + ")";
                    break;
                }
                case 6: {
                    string = ResourceLoader.getDisplay("undo.duplicate.group") + this.groupTitle();
                    break;
                }
                case 4: {
                    string = ResourceLoader.getDisplay("undo.rename.group") + this.groupTitle();
                    break;
                }
                case 7: {
                    String string3 = ResourceLoader.getDisplay("undo.import.records");
                    string3 = Util.substituteText(string3, "$amount", String.valueOf(this.newRecs.length));
                    string = Util.substituteText(string3, "$source", this.newgroup);
                    break;
                }
                default: {
                    string = "??";
                }
            }
            return string;
        }

        public void redo() throws CannotRedoException {
            ContainerView containerView = null;
            super.redo();
            boolean bl = this.file instanceof PwsFileContainer;
            if (bl) {
                containerView = ((PwsFileContainer)this.file).getViewHandler();
            }
            try {
                switch (this.type) {
                    case 0: {
                        this.file.updateRecord(this.newRecs[0].getRecord());
                        break;
                    }
                    case 1: {
                        this.file.addRecord(this.newRecs[0].getRecord());
                        break;
                    }
                    case 3: 
                    case 6: {
                        this.file.addRecordList(this.newRecs);
                        if (!bl) break;
                        containerView.setSelectedWrappers(this.newRecs);
                        break;
                    }
                    case 7: {
                        this.file.deleteEntries(this.oldRecs);
                        this.file.addRecordList(this.newRecs);
                        this.file.addRecordList(this.copyRecs);
                        if (!bl) break;
                        containerView.setSelectedWrappers(this.newRecs);
                        break;
                    }
                    case 2: 
                    case 5: {
                        this.file.updateRecordList(this.newRecs);
                        if (!bl) break;
                        Thread.sleep(50L);
                        containerView.setSelectedWrappers(this.newRecs);
                        break;
                    }
                    case 4: {
                        this.file.updateRecordList(this.newRecs);
                        break;
                    }
                }
                MenuHandler.undoUpdated();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new CannotUndoException();
            }
        }

        public void undo() throws CannotUndoException {
            ContainerView containerView = null;
            super.undo();
            boolean bl = this.file instanceof PwsFileContainer;
            if (bl) {
                containerView = ((PwsFileContainer)this.file).getViewHandler();
            }
            try {
                switch (this.type) {
                    case 0: {
                        this.file.updateRecord(this.oldRecs[0].getRecord());
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        this.file.deleteEntries(this.newRecs);
                        if (!bl) break;
                        containerView.setSelectedIndex(-1);
                        break;
                    }
                    case 7: {
                        this.file.deleteEntries(this.newRecs);
                        this.file.deleteEntries(this.copyRecs);
                        if (bl) {
                            containerView.setSelectedIndex(-1);
                        }
                        if (this.oldRecs == null) break;
                        this.file.addRecordList(this.oldRecs);
                        if (!bl) break;
                        containerView.setSelectedWrappers(this.oldRecs);
                        break;
                    }
                    case 2: 
                    case 5: {
                        this.file.updateRecordList(this.oldRecs);
                        if (!bl) break;
                        Thread.sleep(50L);
                        containerView.setSelectedWrappers(this.oldRecs);
                        break;
                    }
                    case 4: {
                        this.file.updateRecordList(this.oldRecs);
                        break;
                    }
                }
                MenuHandler.undoUpdated();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new CannotUndoException();
            }
        }
    }

    public static class DeleteRecordEdit
    extends AbstractUndoableEdit {
        private PwsFileSocket file;
        private DefaultRecordWrapper[] delRecs;
        private String group;
        private long updateTime;

        public DeleteRecordEdit(PwsFileSocket pwsFileSocket, DefaultRecordWrapper[] defaultRecordWrapperArray, String string) {
            if (pwsFileSocket == null | defaultRecordWrapperArray == null) {
                throw new NullPointerException();
            }
            if (defaultRecordWrapperArray.length == 0) {
                throw new IllegalArgumentException("empty record list");
            }
            this.file = pwsFileSocket;
            this.delRecs = defaultRecordWrapperArray;
            this.group = string;
            this.updateTime = System.currentTimeMillis();
        }

        public long getUpdateTime() {
            return this.updateTime;
        }

        public void die() {
            super.die();
            Log.debug(5, "-- die UndoableEdit " + this.toString());
            this.delRecs = null;
            this.file = null;
        }

        public String toString() {
            return this.getPresentationName() + " *** " + super.toString();
        }

        public String getPresentationName() {
            String string = this.group != null ? ResourceLoader.getDisplay("undo.delete.group") + " \"" + this.group + "\" (" + this.delRecs.length + ")" : (this.delRecs.length == 1 ? ResourceLoader.getDisplay("undo.delete.record") + " \"" + this.delRecs[0].toString() + "\"" : ResourceLoader.getDisplay("undo.delete.records") + " (" + this.delRecs.length + ")");
            return string;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.file.deleteEntries(this.delRecs);
            if (this.file instanceof PwsFileContainer) {
                ContainerView containerView = ((PwsFileContainer)this.file).getViewHandler();
                containerView.setSelectedItems(null);
            }
            MenuHandler.undoUpdated();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                if (this.delRecs.length == 1) {
                    this.file.addRecord(this.delRecs[0].getRecord());
                } else {
                    this.file.addRecordList(new PwsRecordList(this.delRecs));
                    if (this.file instanceof PwsFileContainer) {
                        ContainerView containerView = ((PwsFileContainer)this.file).getViewHandler();
                        containerView.setSelectedWrappers(this.delRecs);
                    }
                }
                MenuHandler.undoUpdated();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new CannotUndoException();
            }
        }
    }
}

