/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.jpws.front.ActionHandler;
import org.jpws.front.GUIService;
import org.jpws.front.Global;
import org.jpws.front.util.ButtonBarListener;
import org.jpws.front.util.DialogButtonBar;
import org.jpws.front.util.ResourceLoader;
import org.jpws.front.util.Util;
import org.jpws.front.util.VerticalFlowLayout;

public class UrlLinkTable
extends JPanel {
    private Dialog parentDlg;
    private UrlTableModel model;
    private ArrayList rowList = new ArrayList();
    private UrlRenderer renderer;
    private MouseAdapter mouseAdapter;
    private ActionListener actionListener;
    private JTable table;
    private JScrollPane scrollPane;
    private JPanel buttonBar;
    private JButton newButton;
    private JButton editButton;
    private JButton deleteButton;
    private String contentString;
    static /* synthetic */ Class array$Ljava$lang$String;

    public UrlLinkTable(Dialog dialog) {
        super(new BorderLayout(0, 3));
        this.parentDlg = dialog;
        this.init();
    }

    public UrlLinkTable(Dialog dialog, String string) {
        super(new BorderLayout(0, 3));
        this.parentDlg = dialog;
        this.init();
        this.setContent(string);
    }

    private void init() {
        this.actionListener = new Actions();
        this.model = new UrlTableModel();
        this.table = new JTable(this.model);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(10, 10));
        this.add((Component)this.scrollPane, "Center");
        this.mouseAdapter = new MouseAdapter();
        this.table.addMouseListener(this.mouseAdapter);
        this.table.setRowHeight(40);
        this.renderer = new UrlRenderer();
        this.table.setDefaultRenderer(array$Ljava$lang$String == null ? (array$Ljava$lang$String = UrlLinkTable.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, this.renderer);
        this.buttonBar = new JPanel(new GridLayout(1, 3));
        this.newButton = this.makeButton("button.new");
        this.buttonBar.add(this.newButton);
        this.editButton = this.makeButton("button.edit");
        this.buttonBar.add(this.editButton);
        this.deleteButton = this.makeButton("button.delete");
        this.buttonBar.add(this.deleteButton);
        this.add((Component)this.buttonBar, "South");
        this.setOpaque(true);
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(ResourceLoader.getDisplay(string));
        jButton.setActionCommand(string);
        jButton.addActionListener(this.actionListener);
        return jButton;
    }

    public void setCellFont(Font font) {
        UrlRenderer.label.setFont(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(String string) {
        this.contentString = string;
        ArrayList arrayList = this.rowList;
        synchronized (arrayList) {
            this.rowList.clear();
            if (string != null) {
                Util.BufferInt bufferInt = new Util.BufferInt();
                while (bufferInt.value < string.length()) {
                    String[] stringArray = Util.CSV.decodeLine(string, bufferInt.value, ',', bufferInt);
                    if (stringArray.length == 0) continue;
                    if (stringArray.length != 2) {
                        String[] stringArray2 = new String[]{stringArray[0], ""};
                        if (stringArray.length > 1) {
                            stringArray2[1] = stringArray[1];
                        }
                        stringArray = stringArray2;
                    }
                    this.rowList.add(stringArray);
                }
            }
            this.model.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent() {
        StringBuffer stringBuffer;
        ArrayList arrayList = this.rowList;
        synchronized (arrayList) {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < this.rowList.size(); ++i) {
                String string = this.getEntry(i);
                if (i != 0) {
                    stringBuffer.append("\r\n");
                }
                stringBuffer.append(string);
            }
        }
        this.contentString = stringBuffer.toString();
        return this.contentString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEntry(int n) {
        ArrayList arrayList = this.rowList;
        synchronized (arrayList) {
            if (n < 0 | n > this.rowList.size()) {
                return null;
            }
            return Util.CSV.encodeLine((String[])this.rowList.get(n), ',');
        }
    }

    public int getListSize() {
        return this.rowList.size();
    }

    public void editRow(int n) {
        if (n > -2 & n < this.rowList.size()) {
            EditDialog editDialog = new EditDialog(n);
            Util.centreWithin(this.parentDlg, editDialog);
            editDialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(int n) {
        if (n > -1 & n < this.rowList.size()) {
            String[] stringArray = (String[])this.rowList.get(n);
            String string = stringArray[0];
            if (string == null || string.length() == 0) {
                string = stringArray[1];
            }
            if (string != null && string.length() > 55) {
                string = string.substring(0, 55) + "....";
            }
            String string2 = ResourceLoader.getDisplay("msg.url.askdelete");
            string2 = Util.substituteText(string2, "$url", Util.htmlEncoded(string));
            if (string == null || GUIService.userConfirm(this.parentDlg, string2)) {
                ArrayList arrayList = this.rowList;
                synchronized (arrayList) {
                    this.rowList.remove(n);
                    this.model.fireTableRowsDeleted(n, n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(String[] stringArray) {
        if (stringArray != null) {
            ArrayList arrayList = this.rowList;
            synchronized (arrayList) {
                int n = this.rowList.size();
                this.rowList.add(stringArray);
                this.model.fireTableRowsInserted(n, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow(int n, String[] stringArray) {
        if (stringArray != null & n > -1 & n < this.rowList.size()) {
            ArrayList arrayList = this.rowList;
            synchronized (arrayList) {
                String[] stringArray2 = (String[])this.rowList.get(n);
                stringArray2[0] = stringArray[0];
                stringArray2[1] = stringArray[1];
                this.model.fireTableRowsUpdated(n, n);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class UrlRenderer
    extends DefaultTableCellRenderer {
        static JLabel label = new JLabel();
        static Color normalColor = Color.white;
        static Color selectedColor = new Color(15787660);

        private UrlRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && object.getClass().equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = UrlLinkTable.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                String string;
                String[] stringArray = (String[])object;
                String string2 = stringArray[0];
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = stringArray[1]) == null) {
                    string = "";
                }
                String string3 = "<html>" + Util.htmlEncoded(string2) + "<p><font color=\"blue\"><i><b>" + Util.htmlEncoded(string) + "</b></i></font></html>";
                label.setText(string3);
                int n3 = UrlRenderer.label.getPreferredSize().height + 4;
                if (jTable.getRowHeight(n) != n3) {
                    jTable.setRowHeight(n, n3);
                }
                label.setBackground(bl ? selectedColor : normalColor);
                return label;
            }
            return null;
        }

        static {
            label.setOpaque(true);
        }
    }

    private class UrlTableModel
    extends AbstractTableModel {
        String columnTitle = "Site / URL";

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return null;
        }

        public int getRowCount() {
            return UrlLinkTable.this.rowList.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n > -1 & n < UrlLinkTable.this.rowList.size()) {
                return UrlLinkTable.this.rowList.get(n);
            }
            return null;
        }

        public Class getColumnClass(int n) {
            return array$Ljava$lang$String == null ? (array$Ljava$lang$String = UrlLinkTable.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
        }
    }

    private class MouseAdapter
    extends java.awt.event.MouseAdapter {
        private MouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ActionHandler.resetIdleTime();
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1) {
                int n = ((JTable)mouseEvent.getSource()).rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                String[] stringArray = (String[])UrlLinkTable.this.rowList.get(n);
                String string = stringArray[1];
                if (string != null && string.length() > 0) {
                    try {
                        URL uRL = new URL(string);
                        Global.startBrowser(uRL);
                    }
                    catch (Exception exception) {
                        string = ResourceLoader.getDisplay("msg.url.failbrowser");
                        GUIService.failureMessage(string, exception);
                    }
                }
            }
        }
    }

    private class EditDialog
    extends JDialog
    implements ButtonBarListener {
        DialogButtonBar buttonBar;
        JTextField targetFld;
        JTextArea textArea;
        boolean createNew;
        int dataRef;

        public EditDialog(int n) {
            super(UrlLinkTable.this.parentDlg, true);
            this.createNew = n == -1;
            this.init();
            this.setData(n);
        }

        private void init() {
            String string = this.createNew ? "dlg.urls.create" : "dlg.urls.edit";
            string = ResourceLoader.getDisplay(string);
            this.setTitle(string);
            this.setResizable(false);
            this.buttonBar = new DialogButtonBar(3, true);
            this.buttonBar.setButtonBarListener(this);
            this.getContentPane().add((Component)this.buttonBar, "South");
            JPanel jPanel = new JPanel(new VerticalFlowLayout(4, true));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 8, 0, 8));
            this.getContentPane().add((Component)jPanel, "Center");
            jPanel.add(new JLabel(ResourceLoader.getDisplay("urldlg.description")));
            this.textArea = new JTextArea();
            this.textArea.setLineWrap(true);
            ActionHandler.registerTextEditor(this.textArea);
            UrlLinkTable.this.scrollPane = new JScrollPane(this.textArea);
            UrlLinkTable.this.scrollPane.setHorizontalScrollBarPolicy(31);
            UrlLinkTable.this.scrollPane.setPreferredSize(new Dimension(320, 100));
            jPanel.add(UrlLinkTable.this.scrollPane);
            jPanel.add(Box.createVerticalStrut(3));
            jPanel.add(new JLabel(ResourceLoader.getDisplay("urldlg.targeturl")));
            this.targetFld = new JTextField();
            jPanel.add(this.targetFld);
            this.pack();
        }

        private void setData(int n) {
            if (n < 0 | n > UrlLinkTable.this.rowList.size()) {
                this.dataRef = -1;
            } else {
                String[] stringArray = (String[])UrlLinkTable.this.rowList.get(n);
                this.targetFld.setText(stringArray[1]);
                this.textArea.setText(stringArray[0]);
                this.dataRef = n;
            }
        }

        public void dispose() {
            super.dispose();
            if (this.buttonBar != null) {
                this.buttonBar.destruct();
                this.buttonBar = null;
            }
        }

        public void cancelButtonPerformed() {
            this.dispose();
        }

        public void helpButtonPerformed() {
        }

        public boolean okButtonPerformed() {
            String string = this.textArea.getText();
            String string2 = this.targetFld.getText();
            String string3 = null;
            if (string.length() == 0 & string2.length() == 0) {
                string3 = "msg.url.failtext";
            } else if (string2.length() > 0) {
                try {
                    new URL(string2);
                }
                catch (Exception exception) {
                    string3 = "msg.url.failurl";
                }
            }
            if (string3 != null) {
                GUIService.infoMessage(this, "dlg.badrecord", string3);
                return false;
            }
            String[] stringArray = new String[]{string, string2};
            if (this.createNew) {
                UrlLinkTable.this.addRow(stringArray);
            } else {
                UrlLinkTable.this.updateRow(this.dataRef, stringArray);
            }
            this.dispose();
            return true;
        }

        public boolean extraButtonPerformed(Object object) {
            return true;
        }
    }

    private class Actions
    implements ActionListener {
        private Actions() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = UrlLinkTable.this.table.getSelectedRow();
            if (string.equals("button.new")) {
                UrlLinkTable.this.editRow(-1);
            } else if (string.equals("button.edit")) {
                if (n != -1) {
                    UrlLinkTable.this.editRow(n);
                }
            } else if (string.equals("button.delete")) {
                UrlLinkTable.this.deleteRow(n);
            }
        }
    }
}

