/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;

public class EditorTextField
extends JTextField {
    private UndoManager undoManager = new UndoManager();
    private static HashMap actionLookup;

    public EditorTextField() {
        this.init();
    }

    public EditorTextField(int n) {
        super(n);
        this.init();
    }

    public EditorTextField(String string) {
        super(string);
        this.init();
    }

    public EditorTextField(Document document, String string, int n) {
        super(document, string, n);
        this.init();
    }

    public EditorTextField(String string, int n) {
        super(string, n);
        this.init();
    }

    private void init() {
        if (actionLookup == null) {
            Action[] actionArray = this.getActions();
            actionLookup = new HashMap();
            for (int i = 0; i < actionArray.length; ++i) {
                actionLookup.put(actionArray[i].getValue("Name"), actionArray[i]);
            }
        }
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.modifyKeystrokes();
    }

    private void modifyKeystrokes() {
        Keymap keymap = this.getKeymap();
        Keymap keymap2 = JTextComponent.addKeymap("JPWS_TextAreaKeymap", keymap);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(87, 2);
        Action action = (Action)actionLookup.get("select-word");
        keymap2.addActionForKeyStroke(keyStroke, action);
        keyStroke = KeyStroke.getKeyStroke(76, 2);
        action = (Action)actionLookup.get("select-line");
        keymap2.addActionForKeyStroke(keyStroke, action);
        keyStroke = KeyStroke.getKeyStroke(80, 2);
        action = (Action)actionLookup.get("select-paragraph");
        keymap2.addActionForKeyStroke(keyStroke, action);
        keyStroke = KeyStroke.getKeyStroke(90, 2);
        keymap2.addActionForKeyStroke(keyStroke, new UndoAction());
        keyStroke = KeyStroke.getKeyStroke(89, 2);
        keymap2.addActionForKeyStroke(keyStroke, new RedoAction());
        this.setKeymap(keymap2);
    }

    public void clearUndoList() {
        this.undoManager.discardAllEdits();
    }

    private class RedoAction
    extends TextAction {
        public RedoAction() {
            super("Redo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorTextField.this.undoManager.canRedo()) {
                EditorTextField.this.undoManager.redo();
            }
        }
    }

    private class UndoAction
    extends TextAction {
        public UndoAction() {
            super("Undo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EditorTextField.this.undoManager.canUndo()) {
                EditorTextField.this.undoManager.undo();
            }
        }
    }
}

