/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.IOException;
import java.net.URL;
import org.jpws.data.Options;
import org.jpws.front.Global;
import org.jpws.front.util.ButtonBarDialog;
import org.jpws.front.util.HtmlDialogPane;

public class HtmlBrowserDialog
extends ButtonBarDialog {
    private HtmlDialogPane htmlPane;
    private String boundsToken;
    private boolean boundsRelative;

    public HtmlBrowserDialog() throws HeadlessException {
        this.init();
    }

    public HtmlBrowserDialog(Dialog dialog, boolean bl) throws HeadlessException {
        super(dialog, 1, bl);
        this.init();
    }

    public HtmlBrowserDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, 1, bl);
        this.init();
    }

    public HtmlBrowserDialog(Dialog dialog, String string, boolean bl) throws HeadlessException {
        this(dialog, bl);
        this.setTitle(string);
    }

    public HtmlBrowserDialog(Frame frame, String string, boolean bl) throws HeadlessException {
        this(frame, bl);
        this.setTitle(string);
    }

    private void init() {
        this.htmlPane = new HtmlDialogPane();
        this.htmlPane.addHyperlinkListener(Global.createHyperLinkListener());
        this.htmlPane.setPreferredSize(new Dimension(500, 400));
        this.htmlPane.getScrollPane().setHorizontalScrollBarPolicy(31);
        this.setResizable(true);
        this.setDialogPanel(this.htmlPane);
    }

    public void setText(String string) {
        this.htmlPane.getEditorPane().setText(string);
    }

    public void setPage(URL uRL) throws IOException {
        this.htmlPane.getEditorPane().setPage(uRL);
    }

    public void setBoundsToken(String string, boolean bl) {
        this.boundsRelative = bl;
        this.boundsToken = string;
    }

    public void show() {
        if (this.boundsToken != null && Options.isOptionSet("rememberScreen")) {
            this.gainBounds(Options.getOptions(), this.boundsToken, this.boundsRelative);
        }
        super.show();
    }

    public void dispose() {
        if (this.boundsToken != null && Options.isOptionSet("rememberScreen")) {
            this.storeBounds(Options.getOptions(), this.boundsToken, this.boundsRelative);
        }
        super.dispose();
    }
}

