/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkListener;

public class HtmlDialogPane
extends JPanel {
    private JEditorPane editor;
    private JScrollPane scroll;

    public HtmlDialogPane() {
        this.init(true);
    }

    public HtmlDialogPane(boolean bl) {
        this.init(bl);
    }

    public HtmlDialogPane(String string) {
        this.init(true);
        this.editor.setText(string);
    }

    public HtmlDialogPane(URL uRL) throws IOException {
        this.init(true);
        this.editor.setPage(uRL);
    }

    private void init(boolean bl) {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.editor = new JEditorPane();
        this.editor.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 0));
        this.editor.setEditable(false);
        this.editor.setOpaque(false);
        this.editor.setContentType("text/html;charset=ISO-8859-1");
        JComponent jComponent = this.editor;
        if (bl) {
            this.scroll = new JScrollPane(this.editor);
            jComponent = this.scroll;
        }
        this.add((Component)jComponent, "Center");
    }

    public JScrollPane getScrollPane() {
        return this.scroll;
    }

    public JEditorPane getEditorPane() {
        return this.editor;
    }

    public void setText(String string) {
        this.editor.setText(string);
    }

    public void setPage(URL uRL) throws IOException {
        this.editor.setPage(uRL);
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.editor.addHyperlinkListener(hyperlinkListener);
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.editor.removeHyperlinkListener(hyperlinkListener);
    }
}

