/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.zip.CRC32;

public final class Util
extends org.jpws.pwslib.global.Util {
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final String CRLF = "\r\n";

    public static synchronized void wipeAFile(File file) throws IOException {
        int n;
        if (!file.isFile()) {
            return;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rws");
        long l = randomAccessFile.length();
        Util.blankFileSpace(randomAccessFile, 0L, l);
        Util.blankFileSpace(randomAccessFile, 0L, l);
        byte[] byArray = new byte[8192];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = -1;
        }
        Util.fillFileSpace(randomAccessFile, 0L, l, byArray, 0);
        Util.fillFileSpace(randomAccessFile, 0L, l, byArray, 0);
        Util.blankFileSpace(randomAccessFile, 0L, l);
        Util.blankFileSpace(randomAccessFile, 0L, l);
        randomAccessFile.seek(0L);
        for (long i = l; i > 0L; i -= (long)n) {
            byArray = org.jpws.pwslib.global.Util.getCryptoRand().nextBytes(8192);
            n = (int)Math.min(i, (long)byArray.length);
            randomAccessFile.write(byArray, 0, n);
        }
        randomAccessFile.close();
        file.delete();
    }

    public static final void blankFileSpace(RandomAccessFile randomAccessFile, long l, long l2) throws IOException {
        Util.fillFileSpace(randomAccessFile, l, l2, new byte[2048], 0);
    }

    public static final void fillFileSpace(RandomAccessFile randomAccessFile, long l, long l2, byte[] byArray, int n) throws IOException {
        if (n > 0) {
            if (l2 % (long)n > 0L) {
                throw new IllegalArgumentException("length / cyclus mismatch");
            }
            if (byArray.length % n > 0) {
                throw new IllegalArgumentException("pattern / cyclus mismatch");
            }
        }
        if (l >= 0L) {
            randomAccessFile.seek(l);
        }
        while (l2 > 0L) {
            int n2 = (int)Math.min(l2, (long)byArray.length);
            randomAccessFile.write(byArray, 0, n2);
            l2 -= (long)n2;
        }
    }

    public static Point centreWithin(Rectangle rectangle, Dimension dimension) {
        Point point = new Point();
        point.x = rectangle.x + (rectangle.width - dimension.width >> 1);
        point.y = rectangle.y + (rectangle.height - dimension.height >> 1);
        return point;
    }

    public static void centreWithin(Component component, Component component2) {
        Point point = Util.centreWithin(component.getBounds(), component2.getSize());
        Util.setCorrectedLocation(component2, point);
    }

    public static void scatter(byte[] byArray, int n, boolean bl) {
        int n2 = bl ? 13 : -13;
        int n3 = n / 16;
        int n4 = n % 16;
        if (n4 > 0) {
            ++n3;
        }
        int n5 = 15;
        int n6 = 4;
        int n7 = 0;
        for (int i = 0; i < n3; ++i) {
            if (i == n3 - 1 && n4 > 0) {
                n5 = n4 - 1;
                n6 = n4 / 4;
            }
            for (int j = 0; j < n6; ++j) {
                int n8 = j * 2;
                int n9 = n5 - n8;
                byte by = byArray[n7 + n8];
                byArray[n7 + n8] = (byte)(byArray[n7 + n9] + n2);
                byArray[n7 + n9] = (byte)(by + n2);
            }
            n7 += 16;
        }
    }

    public static void setCorrectedLocation(Component component, Point point) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        int n = dimension.width - point.x - dimension2.width;
        if (n < 0) {
            point.x += n;
        }
        if ((n = dimension.height - point.y - dimension2.height) < 0) {
            point.y += n;
        }
        point.x = Math.max(0, point.x);
        point.y = Math.max(0, point.y);
        component.setLocation(point);
    }

    public static String fileNameOfPath(String string) {
        if (string == null) {
            return "";
        }
        File file = new File(string);
        return file.getName();
    }

    public static String pathNameOfPath(String string) {
        if (string == null) {
            return "";
        }
        File file = new File(string);
        String string2 = file.getParent();
        return string2 == null ? "" : string2;
    }

    public static String htmlEncoded(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 3);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("<br>");
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream;
        block12: {
            FileInputStream fileInputStream = null;
            fileOutputStream = null;
            if (file == null | file2 == null) {
                throw new IllegalArgumentException("null pointer");
            }
            if (file.equals(file2)) {
                throw new IllegalArgumentException("illegal self reference");
            }
            byte[] byArray = new byte[2048];
            try {
                try {
                    int n;
                    File file3 = file.getAbsoluteFile().getParentFile();
                    if (!file2.isAbsolute()) {
                        file2 = new File(file3, file2.getPath());
                    }
                    Util.ensureFilePath(file2, file3);
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                    long l = file.lastModified();
                    CRC32 cRC32 = new CRC32();
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                        cRC32.update(byArray, 0, n);
                    }
                    fileInputStream.close();
                    fileOutputStream.close();
                    int n2 = (int)cRC32.getValue();
                    file2.setLastModified(l);
                    fileInputStream = new FileInputStream(file2);
                    cRC32.reset();
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        cRC32.update(byArray, 0, n);
                    }
                    if (n2 != (int)cRC32.getValue()) {
                        throw new StreamCorruptedException("bad copy CRC");
                    }
                    Object var13_10 = null;
                    if (fileInputStream == null) break block12;
                }
                catch (IOException iOException) {
                    System.err.println("*** error during file copy: " + file2.getAbsolutePath());
                    System.err.println(iOException);
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            fileInputStream.close();
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
    }

    public static boolean ensureFilePath(File file, File file2) {
        File file3 = file.getParentFile();
        if (file3 != null) {
            return Util.ensureDirectory(file3, file2);
        }
        return true;
    }

    public static boolean ensureDirectory(File file, File file2) {
        boolean bl = true;
        if (file == null) {
            throw new IllegalArgumentException("dir = null");
        }
        if (!file.isAbsolute()) {
            file = new File(file2, file.getPath());
        }
        if (!file.isDirectory()) {
            boolean bl2 = bl = !file.isFile() && file.mkdirs();
            if (!bl) {
                System.err.println("failed while trying to create directory: " + file.toString());
            }
        }
        return bl;
    }

    public static int textVariance(char[] cArray) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < cArray.length; ++i) {
            bitSet.set(cArray[i]);
        }
        return bitSet.cardinality();
    }

    public static boolean isFileProtocol(URL uRL) {
        return uRL != null && uRL.getProtocol().equals("file");
    }

    public static boolean isFileProtocol(String string) {
        try {
            return Util.isFileProtocol(Util.makeFileURL(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static URL makeFileURL(String string) throws IOException {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                file = file.getCanonicalFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string2 = file.getAbsolutePath();
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            uRL = new URL("file:" + string2);
        }
        return uRL;
    }

    public static String normalizedPath(String string, boolean bl) {
        String string2 = string.replace('\\', '/');
        if (bl && !string2.endsWith("/")) {
            string2 = string2.concat("/");
        }
        return string2;
    }

    public static String condensedNumber(String string, int n) {
        if (n < 0 | n > 16) {
            throw new IllegalArgumentException("radix invalid");
        }
        String string2 = "0123456789abcdef".substring(0, n);
        String string3 = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string3.length(); ++i) {
            if (string2.indexOf(string3.charAt(i)) <= -1) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String number(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        String string = String.valueOf(l);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String standardTimeString(long l) {
        return Util.standardTimeString(l, TimeZone.getDefault());
    }

    public static String standardTimeString(long l, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeInMillis(l);
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(Util.number(gregorianCalendar.get(1), 4));
        stringBuffer.append('-');
        stringBuffer.append(Util.number(gregorianCalendar.get(2) + 1, 2));
        stringBuffer.append('-');
        stringBuffer.append(Util.number(gregorianCalendar.get(5), 2));
        stringBuffer.append(' ');
        stringBuffer.append(Util.number(gregorianCalendar.get(11), 2));
        stringBuffer.append(':');
        stringBuffer.append(Util.number(gregorianCalendar.get(12), 2));
        stringBuffer.append(':');
        stringBuffer.append(Util.number(gregorianCalendar.get(13), 2));
        return stringBuffer.toString();
    }

    public static String xmlTimeString(long l) {
        String string = Util.standardTimeString(l, GMT);
        return Util.substituteText(string, " ", "T");
    }

    public static long timeFromString(String string, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (!Character.isDigit(c)) continue;
            stringBuffer.append(c);
        }
        string2 = stringBuffer.toString();
        int n = string2.length();
        if (n != 8 & n != 12 & n != 14) {
            return -1L;
        }
        int n2 = Integer.parseInt(string2.substring(0, 4));
        int n3 = Integer.parseInt(string2.substring(4, 6));
        int n4 = Integer.parseInt(string2.substring(6, 8));
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n >= 12) {
            n7 = Integer.parseInt(string2.substring(8, 10));
            n6 = Integer.parseInt(string2.substring(10, 12));
        }
        if (n == 14) {
            n5 = Integer.parseInt(string2.substring(12, 14));
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.set(n2, n3 - 1, n4, n7, n6, n5);
        return gregorianCalendar.getTimeInMillis();
    }

    public static long timeFromSECPath(String string) {
        int n = string.lastIndexOf("SEC-");
        String string2 = string.substring(n + 4, n + 19);
        return Util.timeFromString(string2, GMT);
    }

    public static long longFromString(String string) {
        long l = 0L;
        if (string != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public static URL extractURL(String string) {
        if (string != null) {
            String[] stringArray = string.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    URL uRL = new URL(stringArray[i]);
                    return uRL;
                }
                catch (MalformedURLException malformedURLException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static class BufferInt {
        public int value;

        public BufferInt() {
        }

        public BufferInt(int n) {
            this.value = n;
        }
    }

    public static class CSV {
        public static String quoteText(String string) {
            if (string == null) {
                return null;
            }
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            stringBuffer.append('\"');
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    stringBuffer.append('\"');
                }
                stringBuffer.append(c);
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }

        public static int searchQuoteEnd(String string, int n) {
            int n2 = string.length();
            int n3 = n2 - 1;
            if (n <= 0 | n >= n2) {
                throw new IllegalArgumentException("illegal start value");
            }
            for (int i = n; i < n2; ++i) {
                if (string.charAt(i) != '\"') continue;
                if (i == n3 || string.charAt(i + 1) != '\"') {
                    return i + 1;
                }
                ++i;
            }
            return -1;
        }

        public static String unquoteText(String string) {
            if (string == null) {
                return null;
            }
            int n = (string = string.trim()).length();
            if (n < 2 || string.charAt(0) != '\"' || string.charAt(n - 1) != '\"') {
                throw new IllegalArgumentException("unquoted text");
            }
            String string2 = string.substring(1, n - 1);
            if (string2.indexOf(34) == -1) {
                return string2;
            }
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 1; i < n - 1; ++i) {
                char c = string.charAt(i);
                if (c == '\"' && i < n - 2 && string.charAt(i + 1) == '\"') {
                    ++i;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        public static String encodeLine(String[] stringArray, char c) {
            if (c == ' ' | c == '\"' | c == '\r' | c == '\n') {
                throw new IllegalArgumentException("illegal separator");
            }
            StringBuffer stringBuffer = new StringBuffer(256);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null) {
                    string = "";
                }
                boolean bl = false;
                if (string.length() > 0) {
                    boolean bl2 = string.indexOf(c) > -1 || string.indexOf(34) > -1 || string.indexOf("\n") > -1;
                    boolean bl3 = string.startsWith(" ") || string.endsWith(" ");
                    bl = bl2 | bl3;
                }
                if (bl) {
                    string = CSV.quoteText(string);
                }
                stringBuffer.append(string);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        public static String[] decodeLine(String string, int n, char c, BufferInt bufferInt) {
            int n2 = string.length();
            if (c == ' ' | c == '\"' | c == '\r' | c == '\n') {
                throw new IllegalArgumentException("illegal separator");
            }
            if (string.length() == 0) {
                return new String[0];
            }
            if (n < 0 | n > n2 - 1) {
                throw new IllegalArgumentException("illegal start position");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n3 = n;
            boolean bl = false;
            char c2 = '\u0000';
            while (!bl) {
                String string2;
                int n4;
                c2 = string.charAt(n3);
                if (c2 == '\"') {
                    if (n3 == n2 - 1) {
                        throw new IllegalStateException();
                    }
                    n4 = CSV.searchQuoteEnd(string, n3 + 1);
                    if (n4 == -1) {
                        throw new IllegalStateException();
                    }
                    string2 = CSV.unquoteText(string.substring(n3, n4));
                    n3 = n4;
                    while (n3 < n2 && (c2 = string.charAt(n3++)) != c && c2 != '\n') {
                    }
                } else {
                    int n5 = n3;
                    while (n3 < n2 && (c2 = string.charAt(n3++)) != c && c2 != '\n') {
                    }
                    if (c2 == '\n') {
                        bl = true;
                        for (n4 = n3 - 1; n4 > 0 && string.charAt(n4 - 1) == '\r'; --n4) {
                        }
                    } else {
                        n4 = c2 == c ? n3 - 1 : n3;
                    }
                    string2 = string.substring(n5, n4);
                }
                arrayList.add(string2);
                if (!((bl |= n3 >= n2) & c2 == c)) continue;
                arrayList.add("");
            }
            bufferInt.value = n3;
            return arrayList.toArray(new String[0]);
        }

        public static String[] decodeLine(String string, int n, char c) {
            return CSV.decodeLine(string, n, c, new BufferInt());
        }
    }
}

