/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.front.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalFlowLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int vgap = 0;
    private int alignment = 0;
    private boolean hfill;
    private boolean vfill;

    public VerticalFlowLayout() {
        this(0);
    }

    public VerticalFlowLayout(int n) {
        this.vgap = n < 0 ? 0 : n;
    }

    public VerticalFlowLayout(int n, boolean bl) {
        this(n);
        this.hfill = bl;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        int n;
        Insets insets = container.getInsets();
        int n2 = container.getSize().width - insets.left - insets.right;
        int n3 = container.getSize().height - insets.top - insets.bottom;
        int n4 = container.getComponentCount();
        int n5 = insets.top;
        int n6 = 0;
        int n7 = 0;
        if (this.vfill) {
            for (n = 0; n < n4; ++n) {
                if (!container.getComponent(n).isVisible()) continue;
                ++n6;
            }
            n7 = (n3 - (n6 - 1) * this.vgap) / n6;
        }
        for (n = 0; n < n4; ++n) {
            Component component = container.getComponent(n);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            int n8 = insets.left;
            if (!this.hfill) {
                if (this.alignment == 2) {
                    n8 += n2 - dimension.width;
                } else if (this.alignment == 1) {
                    n8 += (n2 - dimension.width) / 2;
                }
            }
            int n9 = this.vfill ? n7 : dimension.height;
            component.setBounds(n8, n5, this.hfill ? n2 : dimension.width, n9);
            n5 += n9 + this.vgap;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getMinimumSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        Dimension dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom + this.vgap * n3);
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        Dimension dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom + this.vgap * n3);
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setAlignment(int n) {
        this.alignment = n == 2 ? 2 : (n == 1 ? 1 : 0);
    }

    public void setHorizontalFill(boolean bl) {
        this.hfill = bl;
    }

    public void setVerticalFill(boolean bl) {
        this.vfill = bl;
    }
}

