/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.crypto;

import org.jpws.pwslib.crypto.BlowfishECB2;
import org.jpws.pwslib.crypto.CipherModeCBC;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.global.Util;

public class BlowfishCipher
implements PwsCipher {
    private PwsCipher ciph;

    public BlowfishCipher() {
        this.ciph = new BlowfishECB2(Util.getCryptoRand().nextBytes(48));
    }

    public BlowfishCipher(byte[] byArray) {
        this.ciph = new BlowfishECB2(byArray);
    }

    public BlowfishCipher(byte[] byArray, byte[] byArray2) {
        this.ciph = new CipherModeCBC(new BlowfishECB2(byArray), byArray2);
    }

    public synchronized byte[] decrypt(byte[] byArray) {
        return this.decrypt(byArray, 0, byArray.length);
    }

    public synchronized byte[] encrypt(byte[] byArray) {
        return this.encrypt(byArray, 0, byArray.length);
    }

    public synchronized byte[] decrypt(byte[] byArray, int n, int n2) {
        return this.ciph.decrypt(byArray, n, n2);
    }

    public synchronized byte[] encrypt(byte[] byArray, int n, int n2) {
        return this.ciph.encrypt(byArray, n, n2);
    }

    public int getBlockSize() {
        return this.ciph.getBlockSize();
    }

    public static boolean self_test() {
        return BlowfishECB2.selfTest();
    }
}

