/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.crypto;

import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.global.Util;

public class CipherModeCBC
implements PwsCipher {
    public static final int ENCRYPTING = 1;
    public static final int DECRYPTING = 2;
    private PwsCipher cipher;
    private int blocksize;
    private int direction;
    private byte[] vector;
    private byte[] cbuf;

    public CipherModeCBC(PwsCipher pwsCipher, byte[] byArray) {
        if (pwsCipher instanceof CipherModeCBC) {
            throw new IllegalArgumentException("input cipher must be ecb-cipher, is cbc");
        }
        this.blocksize = pwsCipher.getBlockSize();
        if (this.blocksize == 0) {
            throw new IllegalArgumentException("input cipher must be block-cipher");
        }
        if (byArray.length < this.blocksize) {
            throw new IllegalArgumentException("illegal IV data length");
        }
        this.cipher = pwsCipher;
        this.vector = Util.arraycopy(byArray, this.blocksize);
        this.cbuf = new byte[this.blocksize];
    }

    public CipherModeCBC(PwsCipher pwsCipher) {
        this(pwsCipher, new byte[pwsCipher.getBlockSize()]);
    }

    public byte[] decrypt(byte[] byArray) {
        return this.decrypt(byArray, 0, byArray.length);
    }

    public synchronized byte[] decrypt(byte[] byArray, int n, int n2) {
        if (this.direction == 1) {
            throw new IllegalStateException("mismatching crypting direction");
        }
        this.direction = 2;
        if (n2 % this.blocksize != 0) {
            throw new IllegalArgumentException("illegal data length");
        }
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[n2];
        int n3 = n2 / this.blocksize;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            System.arraycopy(byArray, n + n4, this.cbuf, 0, this.blocksize);
            byte[] byArray4 = this.cipher.decrypt(this.cbuf);
            byArray2 = Util.XOR_buffers(byArray4, this.vector);
            System.arraycopy(byArray2, 0, byArray3, n4, this.blocksize);
            Util.destroyBytes(byArray2);
            this.vector = Util.arraycopy(this.cbuf);
            n4 += this.blocksize;
        }
        return byArray3;
    }

    public byte[] encrypt(byte[] byArray) {
        return this.encrypt(byArray, 0, byArray.length);
    }

    public synchronized byte[] encrypt(byte[] byArray, int n, int n2) {
        if (this.direction == 2) {
            throw new IllegalStateException("mismatching crypting direction");
        }
        this.direction = 1;
        if (n2 % this.blocksize != 0) {
            throw new IllegalArgumentException("illegal data length");
        }
        byte[] byArray2 = new byte[n2];
        int n3 = n2 / this.blocksize;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            System.arraycopy(byArray, n + n4, this.cbuf, 0, this.blocksize);
            byte[] byArray3 = Util.XOR_buffers(this.cbuf, this.vector);
            byte[] byArray4 = this.cipher.encrypt(byArray3);
            System.arraycopy(byArray4, 0, byArray2, n4, this.blocksize);
            this.vector = byArray4;
            n4 += this.blocksize;
        }
        return byArray2;
    }

    public int getBlockSize() {
        return this.blocksize;
    }

    public int getDirection() {
        return this.direction;
    }

    public byte[] getVector() {
        return this.vector;
    }
}

