/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.crypto;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import org.jpws.pwslib.crypto.SHA1;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.Util;

public class CryptoRandom {
    private static long timerstart = System.currentTimeMillis();
    private static int instanceCounter;
    private int instanceID;
    private Random rand = new Random();
    private byte[] pool;
    private byte[] data = new byte[40];
    private byte[] userInit;
    private long counter;
    private int loops = 16;
    private int pos;

    public CryptoRandom() {
        this.init(null);
    }

    public CryptoRandom(int n) {
        this(n, null);
    }

    public CryptoRandom(byte[] byArray) {
        this.init(byArray);
    }

    public CryptoRandom(int n, byte[] byArray) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.loops = n;
        this.init(byArray);
    }

    private void init(byte[] byArray) {
        this.instanceID = instanceCounter++;
        this.collectPool(byArray);
        this.recalculate();
    }

    private void collectPool(byte[] byArray) {
        if (Log.getLogLevel() >= 9) {
            Log.log(9, "(CryptoRandom) [" + this.instanceID + "] collecting pool data");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.write(this.data);
            long l = System.currentTimeMillis();
            dataOutputStream.writeLong(l);
            dataOutputStream.writeLong(l - timerstart);
            byte[] byArray2 = new byte[40];
            this.rand.nextBytes(byArray2);
            dataOutputStream.write(byArray2);
            if (byArray == null && (byArray = this.getUserSeed()) != null & Log.getDebugLevel() >= 9) {
                Log.debug(9, "(CryptoRandom) [" + this.instanceID + "] received user pool data, fingerprint: " + Util.bytesToHex(Util.fingerPrint(byArray)));
            }
            if (byArray == null) {
                byArray = this.userInit;
            }
            if (byArray != null) {
                dataOutputStream.write(byArray);
                this.userInit = byArray;
            }
            dataOutputStream.writeInt(Thread.currentThread().hashCode());
            Runtime runtime = Runtime.getRuntime();
            dataOutputStream.writeLong(runtime.totalMemory());
            dataOutputStream.writeLong(runtime.maxMemory());
            dataOutputStream.writeLong(runtime.freeMemory());
            dataOutputStream.writeInt(this.hashCode());
            dataOutputStream.writeBytes(System.getProperty("java.library.path", ""));
            dataOutputStream.writeBytes(System.getProperty("java.vm.version", ""));
            dataOutputStream.writeBytes(System.getProperty("user.dir", ""));
            dataOutputStream.writeBytes(System.getProperty("user.name", ""));
            this.pool = byteArrayOutputStream.toByteArray();
            if (Log.getDebugLevel() >= 9) {
                Log.debug(9, "(CryptoRandom) [" + this.instanceID + "] pool data fingerprint: " + Util.bytesToHex(Util.fingerPrint(this.pool)));
            }
        }
        catch (IOException iOException) {
            System.err.println("*** SEVERE ERROR IN INIT CRYPTORANDOM : " + iOException);
        }
    }

    public byte[] getUserSeed() {
        return null;
    }

    public synchronized void recollect(byte[] byArray) {
        this.collectPool(byArray);
    }

    private void recalculate() {
        if (Log.getLogLevel() >= 9) {
            Log.log(9, "(CryptoRandom) [" + this.instanceID + "] recalculating random: " + this.counter);
        }
        SHA1 sHA1 = new SHA1();
        byte[] byArray = new byte[8];
        Util.writeLong(this.counter++, byArray, 0);
        if (this.counter % (long)this.loops == 0L) {
            this.collectPool(null);
        }
        sHA1.update(this.pool);
        sHA1.update(byArray);
        sHA1.finalize();
        byArray = sHA1.getDigest();
        System.arraycopy(byArray, 0, this.data, 0, 20);
        sHA1.reset();
        sHA1.update(this.data);
        sHA1.finalize();
        byArray = sHA1.getDigest();
        System.arraycopy(byArray, 0, this.data, 20, 20);
        this.pos = 0;
        if (Log.getDebugLevel() >= 9) {
            Log.debug(9, "(CryptoRandom) [" + this.instanceID + "] random data: " + Util.bytesToHex(this.data));
        }
    }

    public synchronized byte nextByte() {
        return this.nextByteIntern();
    }

    private byte nextByteIntern() {
        if (this.pos == this.data.length) {
            this.recalculate();
        }
        return this.data[this.pos++];
    }

    public synchronized int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        int n2 = this.nextIntIntern() & Integer.MAX_VALUE;
        int n3 = n2 % n;
        return n3;
    }

    public synchronized int nextInt() {
        return this.nextIntIntern();
    }

    private int nextIntIntern() {
        return this.nextByteIntern() << 24 | this.nextByteIntern() << 16 | this.nextByteIntern() << 8 | this.nextByteIntern();
    }

    public synchronized long nextLong() {
        return (long)this.nextIntIntern() << 32 | (long)this.nextIntIntern();
    }

    public synchronized byte[] nextBytes(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("num < 0");
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.nextByteIntern();
        }
        return byArray;
    }

    public boolean nextBoolean() {
        return this.nextByte() < 0;
    }
}

