/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.crypto;

public class SHA1 {
    public static final int DIGEST_SIZE = 20;
    private int[] m_state = new int[5];
    private long m_lCount;
    private byte[] m_digestBits;
    private int[] m_block = new int[16];
    private int m_nBlockIndex;
    private static final String HEXTAB = "0123456789abcdef";
    private static final String SELFTEST_MESSAGE = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
    private static final byte[] SELFTEST_DIGEST = new byte[]{-124, -104, 62, 68, 28, 59, -46, 110, -70, -82, 74, -95, -7, 81, 41, -27, -27, 70, 112, -15};

    public SHA1() {
        this.m_digestBits = new byte[20];
        this.reset();
    }

    public void clear() {
        int n;
        for (n = 0; n < this.m_state.length; ++n) {
            this.m_state[n] = 0;
        }
        for (n = 0; n < this.m_digestBits.length; ++n) {
            this.m_digestBits[n] = 0;
        }
        for (n = 0; n < this.m_block.length; ++n) {
            this.m_block[n] = 0;
        }
        this.m_lCount = 0L;
        this.m_nBlockIndex = 0;
    }

    public void clearContext() {
        int n;
        for (n = 0; n < this.m_state.length; ++n) {
            this.m_state[n] = 0;
        }
        for (n = 0; n < this.m_block.length; ++n) {
            this.m_block[n] = 0;
        }
        this.m_lCount = 0L;
    }

    static final int rol(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    final int blk0(int n) {
        this.m_block[n] = SHA1.rol(this.m_block[n], 24) & 0xFF00FF00 | SHA1.rol(this.m_block[n], 8) & 0xFF00FF;
        return this.m_block[n];
    }

    final int blk(int n) {
        int n2 = SHA1.rol(this.m_block[n + 13 & 0xF] ^ this.m_block[n + 8 & 0xF] ^ this.m_block[n + 2 & 0xF] ^ this.m_block[n & 0xF], 1);
        this.m_block[n & 0xF] = n2;
        return n2;
    }

    final void r0(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] & (nArray[n3] ^ nArray[n4]) ^ nArray[n4]) + this.blk0(n6) + 1518500249 + SHA1.rol(nArray[n], 5));
        nArray[n2] = SHA1.rol(nArray[n2], 30);
    }

    final void r1(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] & (nArray[n3] ^ nArray[n4]) ^ nArray[n4]) + this.blk(n6) + 1518500249 + SHA1.rol(nArray[n], 5));
        nArray[n2] = SHA1.rol(nArray[n2], 30);
    }

    final void r2(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + this.blk(n6) + 1859775393 + SHA1.rol(nArray[n], 5));
        nArray[n2] = SHA1.rol(nArray[n2], 30);
    }

    final void r3(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + (((nArray[n2] | nArray[n3]) & nArray[n4] | nArray[n2] & nArray[n3]) + this.blk(n6) + -1894007588 + SHA1.rol(nArray[n], 5));
        nArray[n2] = SHA1.rol(nArray[n2], 30);
    }

    final void r4(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5;
        nArray[n7] = nArray[n7] + ((nArray[n2] ^ nArray[n3] ^ nArray[n4]) + this.blk(n6) + -899497514 + SHA1.rol(nArray[n], 5));
        nArray[n2] = SHA1.rol(nArray[n2], 30);
    }

    void transform() {
        int[] nArray = new int[]{this.m_state[0], this.m_state[1], this.m_state[2], this.m_state[3], this.m_state[4]};
        this.r0(nArray, 0, 1, 2, 3, 4, 0);
        this.r0(nArray, 4, 0, 1, 2, 3, 1);
        this.r0(nArray, 3, 4, 0, 1, 2, 2);
        this.r0(nArray, 2, 3, 4, 0, 1, 3);
        this.r0(nArray, 1, 2, 3, 4, 0, 4);
        this.r0(nArray, 0, 1, 2, 3, 4, 5);
        this.r0(nArray, 4, 0, 1, 2, 3, 6);
        this.r0(nArray, 3, 4, 0, 1, 2, 7);
        this.r0(nArray, 2, 3, 4, 0, 1, 8);
        this.r0(nArray, 1, 2, 3, 4, 0, 9);
        this.r0(nArray, 0, 1, 2, 3, 4, 10);
        this.r0(nArray, 4, 0, 1, 2, 3, 11);
        this.r0(nArray, 3, 4, 0, 1, 2, 12);
        this.r0(nArray, 2, 3, 4, 0, 1, 13);
        this.r0(nArray, 1, 2, 3, 4, 0, 14);
        this.r0(nArray, 0, 1, 2, 3, 4, 15);
        this.r1(nArray, 4, 0, 1, 2, 3, 16);
        this.r1(nArray, 3, 4, 0, 1, 2, 17);
        this.r1(nArray, 2, 3, 4, 0, 1, 18);
        this.r1(nArray, 1, 2, 3, 4, 0, 19);
        this.r2(nArray, 0, 1, 2, 3, 4, 20);
        this.r2(nArray, 4, 0, 1, 2, 3, 21);
        this.r2(nArray, 3, 4, 0, 1, 2, 22);
        this.r2(nArray, 2, 3, 4, 0, 1, 23);
        this.r2(nArray, 1, 2, 3, 4, 0, 24);
        this.r2(nArray, 0, 1, 2, 3, 4, 25);
        this.r2(nArray, 4, 0, 1, 2, 3, 26);
        this.r2(nArray, 3, 4, 0, 1, 2, 27);
        this.r2(nArray, 2, 3, 4, 0, 1, 28);
        this.r2(nArray, 1, 2, 3, 4, 0, 29);
        this.r2(nArray, 0, 1, 2, 3, 4, 30);
        this.r2(nArray, 4, 0, 1, 2, 3, 31);
        this.r2(nArray, 3, 4, 0, 1, 2, 32);
        this.r2(nArray, 2, 3, 4, 0, 1, 33);
        this.r2(nArray, 1, 2, 3, 4, 0, 34);
        this.r2(nArray, 0, 1, 2, 3, 4, 35);
        this.r2(nArray, 4, 0, 1, 2, 3, 36);
        this.r2(nArray, 3, 4, 0, 1, 2, 37);
        this.r2(nArray, 2, 3, 4, 0, 1, 38);
        this.r2(nArray, 1, 2, 3, 4, 0, 39);
        this.r3(nArray, 0, 1, 2, 3, 4, 40);
        this.r3(nArray, 4, 0, 1, 2, 3, 41);
        this.r3(nArray, 3, 4, 0, 1, 2, 42);
        this.r3(nArray, 2, 3, 4, 0, 1, 43);
        this.r3(nArray, 1, 2, 3, 4, 0, 44);
        this.r3(nArray, 0, 1, 2, 3, 4, 45);
        this.r3(nArray, 4, 0, 1, 2, 3, 46);
        this.r3(nArray, 3, 4, 0, 1, 2, 47);
        this.r3(nArray, 2, 3, 4, 0, 1, 48);
        this.r3(nArray, 1, 2, 3, 4, 0, 49);
        this.r3(nArray, 0, 1, 2, 3, 4, 50);
        this.r3(nArray, 4, 0, 1, 2, 3, 51);
        this.r3(nArray, 3, 4, 0, 1, 2, 52);
        this.r3(nArray, 2, 3, 4, 0, 1, 53);
        this.r3(nArray, 1, 2, 3, 4, 0, 54);
        this.r3(nArray, 0, 1, 2, 3, 4, 55);
        this.r3(nArray, 4, 0, 1, 2, 3, 56);
        this.r3(nArray, 3, 4, 0, 1, 2, 57);
        this.r3(nArray, 2, 3, 4, 0, 1, 58);
        this.r3(nArray, 1, 2, 3, 4, 0, 59);
        this.r4(nArray, 0, 1, 2, 3, 4, 60);
        this.r4(nArray, 4, 0, 1, 2, 3, 61);
        this.r4(nArray, 3, 4, 0, 1, 2, 62);
        this.r4(nArray, 2, 3, 4, 0, 1, 63);
        this.r4(nArray, 1, 2, 3, 4, 0, 64);
        this.r4(nArray, 0, 1, 2, 3, 4, 65);
        this.r4(nArray, 4, 0, 1, 2, 3, 66);
        this.r4(nArray, 3, 4, 0, 1, 2, 67);
        this.r4(nArray, 2, 3, 4, 0, 1, 68);
        this.r4(nArray, 1, 2, 3, 4, 0, 69);
        this.r4(nArray, 0, 1, 2, 3, 4, 70);
        this.r4(nArray, 4, 0, 1, 2, 3, 71);
        this.r4(nArray, 3, 4, 0, 1, 2, 72);
        this.r4(nArray, 2, 3, 4, 0, 1, 73);
        this.r4(nArray, 1, 2, 3, 4, 0, 74);
        this.r4(nArray, 0, 1, 2, 3, 4, 75);
        this.r4(nArray, 4, 0, 1, 2, 3, 76);
        this.r4(nArray, 3, 4, 0, 1, 2, 77);
        this.r4(nArray, 2, 3, 4, 0, 1, 78);
        this.r4(nArray, 1, 2, 3, 4, 0, 79);
        this.m_state[0] = this.m_state[0] + nArray[0];
        this.m_state[1] = this.m_state[1] + nArray[1];
        this.m_state[2] = this.m_state[2] + nArray[2];
        this.m_state[3] = this.m_state[3] + nArray[3];
        this.m_state[4] = this.m_state[4] + nArray[4];
    }

    public void reset() {
        this.m_state[0] = 1732584193;
        this.m_state[1] = -271733879;
        this.m_state[2] = -1732584194;
        this.m_state[3] = 271733878;
        this.m_state[4] = -1009589776;
        this.m_lCount = 0L;
        this.m_nBlockIndex = 0;
    }

    public void update(byte by) {
        int n = (this.m_nBlockIndex & 3) << 3;
        this.m_lCount += 8L;
        int n2 = this.m_nBlockIndex >> 2;
        this.m_block[n2] = this.m_block[n2] & ~(255 << n);
        int n3 = this.m_nBlockIndex >> 2;
        this.m_block[n3] = this.m_block[n3] | (by & 0xFF) << n;
        ++this.m_nBlockIndex;
        if (this.m_nBlockIndex == 64) {
            this.transform();
            this.m_nBlockIndex = 0;
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            this.update(byArray[n]);
            ++n;
        }
    }

    public void finalize() {
        int n;
        byte[] byArray = new byte[8];
        for (n = 0; n < 8; ++n) {
            byArray[n] = (byte)(this.m_lCount >>> (7 - n << 3) & 0xFFL);
        }
        this.update((byte)-128);
        while (this.m_nBlockIndex != 56) {
            this.update((byte)0);
        }
        for (n = 0; n < byArray.length; ++n) {
            this.update(byArray[n]);
        }
        for (n = 0; n < 20; ++n) {
            this.m_digestBits[n] = (byte)(this.m_state[n >> 2] >> (3 - (n & 3) << 3) & 0xFF);
        }
    }

    public byte[] getDigest() {
        byte[] byArray = new byte[20];
        System.arraycopy(this.m_digestBits, 0, byArray, 0, 20);
        return byArray;
    }

    public int getDigest(byte[] byArray, int n) {
        System.arraycopy(this.m_digestBits, 0, byArray, n, 20);
        return 20;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        for (int i = 0; i < 20; ++i) {
            stringBuffer.append(HEXTAB.charAt(this.m_digestBits[i] >>> 4 & 0xF));
            stringBuffer.append(HEXTAB.charAt(this.m_digestBits[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    public boolean selfTest() {
        SHA1 sHA1 = new SHA1();
        try {
            sHA1.update(SELFTEST_MESSAGE.getBytes("ASCII"));
        }
        catch (Exception exception) {
            return false;
        }
        sHA1.finalize();
        byte[] byArray = sHA1.getDigest();
        for (int i = 0; i < 20; ++i) {
            if (byArray[i] == SELFTEST_DIGEST[i]) continue;
            return false;
        }
        return true;
    }
}

