/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.crypto;

import java.io.PrintWriter;
import java.security.InvalidKeyException;

final class Twofish {
    static final String NAME = "Twofish_Algorithm";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static final int debuglevel = 0;
    static final PrintWriter err = null;
    static final int BLOCK_SIZE = 16;
    private static final int ROUNDS = 16;
    private static final int MAX_ROUNDS = 16;
    private static final int INPUT_WHITEN = 0;
    private static final int OUTPUT_WHITEN = 4;
    private static final int ROUND_SUBKEYS = 8;
    private static final int TOTAL_SUBKEYS = 40;
    private static final int SK_STEP = 0x2020202;
    private static final int SK_BUMP = 0x1010101;
    private static final int SK_ROTL = 9;
    private static final byte[][] P = new byte[][]{{-87, 103, -77, -24, 4, -3, -93, 118, -102, -110, -128, 120, -28, -35, -47, 56, 13, -58, 53, -104, 24, -9, -20, 108, 67, 117, 55, 38, -6, 19, -108, 72, -14, -48, -117, 48, -124, 84, -33, 35, 25, 91, 61, 89, -13, -82, -94, -126, 99, 1, -125, 46, -39, 81, -101, 124, -90, -21, -91, -66, 22, 12, -29, 97, -64, -116, 58, -11, 115, 44, 37, 11, -69, 78, -119, 107, 83, 106, -76, -15, -31, -26, -67, 69, -30, -12, -74, 102, -52, -107, 3, 86, -44, 28, 30, -41, -5, -61, -114, -75, -23, -49, -65, -70, -22, 119, 57, -81, 51, -55, 98, 113, -127, 121, 9, -83, 36, -51, -7, -40, -27, -59, -71, 77, 68, 8, -122, -25, -95, 29, -86, -19, 6, 112, -78, -46, 65, 123, -96, 17, 49, -62, 39, -112, 32, -10, 96, -1, -106, 92, -79, -85, -98, -100, 82, 27, 95, -109, 10, -17, -111, -123, 73, -18, 45, 79, -113, 59, 71, -121, 109, 70, -42, 62, 105, 100, 42, -50, -53, 47, -4, -105, 5, 122, -84, 127, -43, 26, 75, 14, -89, 90, 40, 20, 63, 41, -120, 60, 76, 2, -72, -38, -80, 23, 85, 31, -118, 125, 87, -57, -115, 116, -73, -60, -97, 114, 126, 21, 34, 18, 88, 7, -103, 52, 110, 80, -34, 104, 101, -68, -37, -8, -56, -88, 43, 64, -36, -2, 50, -92, -54, 16, 33, -16, -45, 93, 15, 0, 111, -99, 54, 66, 74, 94, -63, -32}, {117, -13, -58, -12, -37, 123, -5, -56, 74, -45, -26, 107, 69, 125, -24, 75, -42, 50, -40, -3, 55, 113, -15, -31, 48, 15, -8, 27, -121, -6, 6, 63, 94, -70, -82, 91, -118, 0, -68, -99, 109, -63, -79, 14, -128, 93, -46, -43, -96, -124, 7, 20, -75, -112, 44, -93, -78, 115, 76, 84, -110, 116, 54, 81, 56, -80, -67, 90, -4, 96, 98, -106, 108, 66, -9, 16, 124, 40, 39, -116, 19, -107, -100, -57, 36, 70, 59, 112, -54, -29, -123, -53, 17, -48, -109, -72, -90, -125, 32, -1, -97, 119, -61, -52, 3, 111, 8, -65, 64, -25, 43, -30, 121, 12, -86, -126, 65, 58, -22, -71, -28, -102, -92, -105, 126, -38, 122, 23, 102, -108, -95, 29, 61, -16, -34, -77, 11, 114, -89, 28, -17, -47, 83, 62, -113, 51, 38, 95, -20, 118, 42, 73, -127, -120, -18, 33, -60, 26, -21, -39, -59, 57, -103, -51, -83, 49, -117, 1, 24, 35, -35, 31, 78, 45, -7, 72, 79, -14, 101, -114, 120, 92, 88, 25, -115, -27, -104, 87, 103, 127, 5, 100, -81, 99, -74, -2, -11, -73, 60, -91, -50, -23, 104, 68, -32, 77, 67, 105, 41, 46, -84, 21, 89, -88, 10, -98, 110, 71, -33, 52, 53, 106, -49, -36, 34, -55, -64, -101, -119, -44, -19, -85, 18, -94, 13, 82, -69, 2, 47, -87, -41, 97, 30, -76, 80, 4, -10, -62, 22, 37, -122, 86, 85, 9, -66, -111}};
    private static final int P_00 = 1;
    private static final int P_01 = 0;
    private static final int P_02 = 0;
    private static final int P_03 = 1;
    private static final int P_04 = 1;
    private static final int P_10 = 0;
    private static final int P_11 = 0;
    private static final int P_12 = 1;
    private static final int P_13 = 1;
    private static final int P_14 = 0;
    private static final int P_20 = 1;
    private static final int P_21 = 1;
    private static final int P_22 = 0;
    private static final int P_23 = 0;
    private static final int P_24 = 0;
    private static final int P_30 = 0;
    private static final int P_31 = 1;
    private static final int P_32 = 1;
    private static final int P_33 = 0;
    private static final int P_34 = 1;
    private static final int GF256_FDBK = 361;
    private static final int GF256_FDBK_2 = 180;
    private static final int GF256_FDBK_4 = 90;
    private static final int[][] MDS = new int[4][256];
    private static final int RS_GF_FDBK = 333;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    Twofish() {
    }

    static void debug(String string) {
        err.println(">>> Twofish_Algorithm: " + string);
    }

    static void trace(boolean bl, String string) {
    }

    static void trace(String string) {
    }

    private static final int LFSR1(int n) {
        return n >> 1 ^ ((n & 1) != 0 ? 180 : 0);
    }

    private static final int LFSR2(int n) {
        return n >> 2 ^ ((n & 2) != 0 ? 180 : 0) ^ ((n & 1) != 0 ? 90 : 0);
    }

    private static final int Mx_1(int n) {
        return n;
    }

    private static final int Mx_X(int n) {
        return n ^ Twofish.LFSR2(n);
    }

    private static final int Mx_Y(int n) {
        return n ^ Twofish.LFSR1(n) ^ Twofish.LFSR2(n);
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        int n = byArray.length;
        if (n != 8 && n != 16 && n != 24 && n != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        int n2 = n / 8;
        int n3 = 40;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[4];
        int n4 = 0;
        int n5 = 0;
        int n6 = n2 - 1;
        while (n5 < 4 && n4 < n) {
            nArray[n5] = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 24;
            nArray2[n5] = byArray[n4++] & 0xFF | (byArray[n4++] & 0xFF) << 8 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 24;
            nArray3[n6] = Twofish.RS_MDS_Encode(nArray[n5], nArray2[n5]);
            ++n5;
            --n6;
        }
        int[] nArray4 = new int[n3];
        int n7 = 0;
        n5 = 0;
        while (n5 < n3 / 2) {
            int n8 = Twofish.F32(n2, n7, nArray);
            int n9 = Twofish.F32(n2, n7 + 0x1010101, nArray2);
            n9 = n9 << 8 | n9 >>> 24;
            nArray4[2 * n5] = n8 += n9;
            nArray4[2 * n5 + 1] = (n8 += n9) << 9 | n8 >>> 23;
            ++n5;
            n7 += 0x2020202;
        }
        int n10 = nArray3[0];
        int n11 = nArray3[1];
        int n12 = nArray3[2];
        int n13 = nArray3[3];
        int[] nArray5 = new int[1024];
        block8: for (n5 = 0; n5 < 256; ++n5) {
            int n14;
            int n15 = n14 = n5;
            int n16 = n14;
            int n17 = n14;
            switch (n2 & 3) {
                case 1: {
                    nArray5[2 * n5] = MDS[0][P[0][n17] & 0xFF ^ Twofish.b0(n10)];
                    nArray5[2 * n5 + 1] = MDS[1][P[0][n16] & 0xFF ^ Twofish.b1(n10)];
                    nArray5[512 + 2 * n5] = MDS[2][P[1][n15] & 0xFF ^ Twofish.b2(n10)];
                    nArray5[512 + 2 * n5 + 1] = MDS[3][P[1][n14] & 0xFF ^ Twofish.b3(n10)];
                    continue block8;
                }
                case 0: {
                    n17 = P[1][n17] & 0xFF ^ Twofish.b0(n13);
                    n16 = P[0][n16] & 0xFF ^ Twofish.b1(n13);
                    n15 = P[0][n15] & 0xFF ^ Twofish.b2(n13);
                    n14 = P[1][n14] & 0xFF ^ Twofish.b3(n13);
                }
                case 3: {
                    n17 = P[1][n17] & 0xFF ^ Twofish.b0(n12);
                    n16 = P[1][n16] & 0xFF ^ Twofish.b1(n12);
                    n15 = P[0][n15] & 0xFF ^ Twofish.b2(n12);
                    n14 = P[0][n14] & 0xFF ^ Twofish.b3(n12);
                }
                case 2: {
                    nArray5[2 * n5] = MDS[0][P[0][P[0][n17] & 0xFF ^ Twofish.b0(n11)] & 0xFF ^ Twofish.b0(n10)];
                    nArray5[2 * n5 + 1] = MDS[1][P[0][P[1][n16] & 0xFF ^ Twofish.b1(n11)] & 0xFF ^ Twofish.b1(n10)];
                    nArray5[512 + 2 * n5] = MDS[2][P[1][P[0][n15] & 0xFF ^ Twofish.b2(n11)] & 0xFF ^ Twofish.b2(n10)];
                    nArray5[512 + 2 * n5 + 1] = MDS[3][P[1][P[1][n14] & 0xFF ^ Twofish.b3(n11)] & 0xFF ^ Twofish.b3(n10)];
                }
            }
        }
        Object[] objectArray = new Object[]{nArray5, nArray4};
        return objectArray;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        Object[] objectArray = (Object[])object;
        int[] nArray = (int[])objectArray[0];
        int[] nArray2 = (int[])objectArray[1];
        int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        n2 ^= nArray2[0];
        n3 ^= nArray2[1];
        n4 ^= nArray2[2];
        n5 ^= nArray2[3];
        int n6 = 8;
        for (int i = 0; i < 16; i += 2) {
            int n7 = Twofish.Fe32(nArray, n2, 0);
            int n8 = Twofish.Fe32(nArray, n3, 3);
            n4 ^= n7 + n8 + nArray2[n6++];
            n4 = n4 >>> 1 | n4 << 31;
            n5 = n5 << 1 | n5 >>> 31;
            n5 ^= n7 + 2 * n8 + nArray2[n6++];
            n7 = Twofish.Fe32(nArray, n4, 0);
            n8 = Twofish.Fe32(nArray, n5, 3);
            n2 ^= n7 + n8 + nArray2[n6++];
            n2 = n2 >>> 1 | n2 << 31;
            n3 = n3 << 1 | n3 >>> 31;
            n3 ^= n7 + 2 * n8 + nArray2[n6++];
        }
        byte[] byArray2 = new byte[]{(byte)(n4 ^= nArray2[4]), (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)(n5 ^= nArray2[5]), (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24), (byte)(n2 ^= nArray2[6]), (byte)(n2 >>> 8), (byte)(n2 >>> 16), (byte)(n2 >>> 24), (byte)(n3 ^= nArray2[7]), (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24)};
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        Object[] objectArray = (Object[])object;
        int[] nArray = (int[])objectArray[0];
        int[] nArray2 = (int[])objectArray[1];
        int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        n2 ^= nArray2[4];
        n3 ^= nArray2[5];
        n4 ^= nArray2[6];
        n5 ^= nArray2[7];
        int n6 = 39;
        for (int i = 0; i < 16; i += 2) {
            int n7 = Twofish.Fe32(nArray, n2, 0);
            int n8 = Twofish.Fe32(nArray, n3, 3);
            n5 ^= n7 + 2 * n8 + nArray2[n6--];
            n5 = n5 >>> 1 | n5 << 31;
            n4 = n4 << 1 | n4 >>> 31;
            n4 ^= n7 + n8 + nArray2[n6--];
            n7 = Twofish.Fe32(nArray, n4, 0);
            n8 = Twofish.Fe32(nArray, n5, 3);
            n3 ^= n7 + 2 * n8 + nArray2[n6--];
            n3 = n3 >>> 1 | n3 << 31;
            n2 = n2 << 1 | n2 >>> 31;
            n2 ^= n7 + n8 + nArray2[n6--];
        }
        byte[] byArray2 = new byte[]{(byte)(n4 ^= nArray2[0]), (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)(n5 ^= nArray2[1]), (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24), (byte)(n2 ^= nArray2[2]), (byte)(n2 >>> 8), (byte)(n2 >>> 16), (byte)(n2 >>> 24), (byte)(n3 ^= nArray2[3]), (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24)};
        return byArray2;
    }

    public static boolean self_test() {
        return Twofish.self_test(16) && Twofish.self_test(24) && Twofish.self_test(32);
    }

    private static final int b0(int n) {
        return n & 0xFF;
    }

    private static final int b1(int n) {
        return n >>> 8 & 0xFF;
    }

    private static final int b2(int n) {
        return n >>> 16 & 0xFF;
    }

    private static final int b3(int n) {
        return n >>> 24 & 0xFF;
    }

    private static final int RS_MDS_Encode(int n, int n2) {
        int n3;
        int n4 = n2;
        for (n3 = 0; n3 < 4; ++n3) {
            n4 = Twofish.RS_rem(n4);
        }
        n4 ^= n;
        for (n3 = 0; n3 < 4; ++n3) {
            n4 = Twofish.RS_rem(n4);
        }
        return n4;
    }

    private static final int RS_rem(int n) {
        int n2;
        int n3 = (n2 << 1 ^ (((n2 = n >>> 24 & 0xFF) & 0x80) != 0 ? 333 : 0)) & 0xFF;
        int n4 = n2 >>> 1 ^ ((n2 & 1) != 0 ? 166 : 0) ^ n3;
        int n5 = n << 8 ^ n4 << 24 ^ n3 << 16 ^ n4 << 8 ^ n2;
        return n5;
    }

    private static final int F32(int n, int n2, int[] nArray) {
        int n3 = Twofish.b0(n2);
        int n4 = Twofish.b1(n2);
        int n5 = Twofish.b2(n2);
        int n6 = Twofish.b3(n2);
        int n7 = nArray[0];
        int n8 = nArray[1];
        int n9 = nArray[2];
        int n10 = nArray[3];
        int n11 = 0;
        switch (n & 3) {
            case 1: {
                n11 = MDS[0][P[0][n3] & 0xFF ^ Twofish.b0(n7)] ^ MDS[1][P[0][n4] & 0xFF ^ Twofish.b1(n7)] ^ MDS[2][P[1][n5] & 0xFF ^ Twofish.b2(n7)] ^ MDS[3][P[1][n6] & 0xFF ^ Twofish.b3(n7)];
                break;
            }
            case 0: {
                n3 = P[1][n3] & 0xFF ^ Twofish.b0(n10);
                n4 = P[0][n4] & 0xFF ^ Twofish.b1(n10);
                n5 = P[0][n5] & 0xFF ^ Twofish.b2(n10);
                n6 = P[1][n6] & 0xFF ^ Twofish.b3(n10);
            }
            case 3: {
                n3 = P[1][n3] & 0xFF ^ Twofish.b0(n9);
                n4 = P[1][n4] & 0xFF ^ Twofish.b1(n9);
                n5 = P[0][n5] & 0xFF ^ Twofish.b2(n9);
                n6 = P[0][n6] & 0xFF ^ Twofish.b3(n9);
            }
            case 2: {
                n11 = MDS[0][P[0][P[0][n3] & 0xFF ^ Twofish.b0(n8)] & 0xFF ^ Twofish.b0(n7)] ^ MDS[1][P[0][P[1][n4] & 0xFF ^ Twofish.b1(n8)] & 0xFF ^ Twofish.b1(n7)] ^ MDS[2][P[1][P[0][n5] & 0xFF ^ Twofish.b2(n8)] & 0xFF ^ Twofish.b2(n7)] ^ MDS[3][P[1][P[1][n6] & 0xFF ^ Twofish.b3(n8)] & 0xFF ^ Twofish.b3(n7)];
            }
        }
        return n11;
    }

    private static final int Fe32(int[] nArray, int n, int n2) {
        return nArray[2 * Twofish._b(n, n2)] ^ nArray[2 * Twofish._b(n, n2 + 1) + 1] ^ nArray[512 + 2 * Twofish._b(n, n2 + 2)] ^ nArray[512 + 2 * Twofish._b(n, n2 + 3) + 1];
    }

    private static final int _b(int n, int n2) {
        int n3 = 0;
        switch (n2 % 4) {
            case 0: {
                n3 = Twofish.b0(n);
                break;
            }
            case 1: {
                n3 = Twofish.b1(n);
                break;
            }
            case 2: {
                n3 = Twofish.b2(n);
                break;
            }
            case 3: {
                n3 = Twofish.b3(n);
            }
        }
        return n3;
    }

    public static int blockSize() {
        return 16;
    }

    private static boolean self_test(int n) {
        boolean bl = false;
        try {
            int n2;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[16];
            for (n2 = 0; n2 < n; ++n2) {
                byArray[n2] = (byte)n2;
            }
            for (n2 = 0; n2 < 16; ++n2) {
                byArray2[n2] = (byte)n2;
            }
            Object object = Twofish.makeKey(byArray);
            byte[] byArray3 = Twofish.blockEncrypt(byArray2, 0, object);
            byte[] byArray4 = Twofish.blockDecrypt(byArray3, 0, object);
            bl = Twofish.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static String intToString(int n) {
        char[] cArray = new char[8];
        for (int i = 7; i >= 0; --i) {
            cArray[i] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
        }
        return new String(cArray);
    }

    private static String toString(byte[] byArray) {
        return Twofish.toString(byArray, 0, byArray.length);
    }

    private static String toString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = n;
        int n4 = 0;
        while (n3 < n + n2) {
            byte by = byArray[n3++];
            cArray[n4++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n4++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    static {
        long l = System.currentTimeMillis();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        for (int i = 0; i < 256; ++i) {
            int n;
            nArray[0] = n = P[0][i] & 0xFF;
            nArray2[0] = Twofish.Mx_X(n) & 0xFF;
            nArray3[0] = Twofish.Mx_Y(n) & 0xFF;
            nArray[1] = n = P[1][i] & 0xFF;
            nArray2[1] = Twofish.Mx_X(n) & 0xFF;
            nArray3[1] = Twofish.Mx_Y(n) & 0xFF;
            Twofish.MDS[0][i] = nArray[1] << 0 | nArray2[1] << 8 | nArray3[1] << 16 | nArray3[1] << 24;
            Twofish.MDS[1][i] = nArray3[0] << 0 | nArray3[0] << 8 | nArray2[0] << 16 | nArray[0] << 24;
            Twofish.MDS[2][i] = nArray2[1] << 0 | nArray3[1] << 8 | nArray[1] << 16 | nArray3[1] << 24;
            Twofish.MDS[3][i] = nArray2[0] << 0 | nArray[0] << 8 | nArray3[0] << 16 | nArray2[0] << 24;
        }
        l = System.currentTimeMillis() - l;
    }
}

