/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.crypto;

import java.security.InvalidKeyException;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.crypto.Twofish;
import org.jpws.pwslib.global.Util;

class TwofishECB
implements PwsCipher {
    private Object sk;

    public TwofishECB() {
        try {
            this.sk = Twofish.makeKey(Util.getCryptoRand().nextBytes(32));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException(invalidKeyException.toString());
        }
    }

    public TwofishECB(byte[] byArray) {
        try {
            this.sk = Twofish.makeKey(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Invalid key material / " + invalidKeyException.toString());
        }
    }

    public TwofishECB(byte[] byArray, int n, int n2) {
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.sk = Twofish.makeKey(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Invalid key material / " + invalidKeyException.toString());
        }
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) {
        return this.crypting(byArray, n, n2, true);
    }

    public byte[] encrypt(byte[] byArray, int n, int n2) {
        return this.crypting(byArray, n, n2, false);
    }

    public int getBlockSize() {
        return 16;
    }

    private byte[] crypting(byte[] byArray, int n, int n2, boolean bl) {
        if (n < 0 | n2 < 0 | n + n2 > byArray.length) {
            throw new IllegalArgumentException("illegal parameter setting");
        }
        if (n2 % 16 > 0) {
            throw new IllegalArgumentException("illegal data blocklength");
        }
        int n3 = n2 / 16;
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n3; ++i) {
            int n4 = i * 16 + n;
            byte[] byArray3 = bl ? Twofish.blockDecrypt(byArray, n4, this.sk) : Twofish.blockEncrypt(byArray, n4, this.sk);
            System.arraycopy(byArray3, 0, byArray2, n4 - n, 16);
        }
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray) {
        return this.decrypt(byArray, 0, byArray.length);
    }

    public byte[] encrypt(byte[] byArray) {
        return this.encrypt(byArray, 0, byArray.length);
    }
}

