/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import org.jpws.pwslib.global.Util;

class FieldHeader {
    public int length;
    public int type;
    public int blocks;
    public int remLength;
    public byte[] data;

    public FieldHeader(byte[] byArray, int n) {
        long l = Util.readLongLittle(byArray, 0);
        this.length = (int)l;
        if (this.length < 0) {
            this.length = Integer.MAX_VALUE;
        }
        this.type = (int)(l >>> 32) & 0xFF;
        int n2 = byArray.length - 5;
        if (n == 3) {
            this.data = Util.arraycopy(byArray, 5, Math.min(n2, this.length));
            this.remLength = Math.max(0, this.length - n2);
        } else {
            this.remLength = this.length;
        }
        this.blocks = this.remLength / byArray.length;
        if (this.remLength % byArray.length > 0 || n < 3 & this.remLength == 0) {
            ++this.blocks;
        }
    }

    public void clear() {
        Util.destroyBytes(this.data);
        this.data = null;
        this.length = 0;
        this.type = 0;
        this.blocks = 0;
        this.remLength = 0;
    }
}

