/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.jpws.pwslib.crypto.CryptoRandom;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.crypto.SHA256;
import org.jpws.pwslib.crypto.TwofishCipher;
import org.jpws.pwslib.data.BlockInputStream;
import org.jpws.pwslib.data.HeaderFieldList;
import org.jpws.pwslib.data.PwsBlockInputStream;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.exception.UnsupportedFileVersionException;
import org.jpws.pwslib.global.Global;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.PwsChecksum;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.global.Util;
import org.jpws.pwslib.persist.V3_InputStream;

public class PwsFileHeaderV3 {
    public static final int JPWS_OPTIONS_TYPE = 64;
    public static final int PWS_PREFS_TYPE = 2;
    public static final int FILE_UUID_TYPE = 1;
    public static final int TREE_DISPLAY_TYPE = 3;
    public static final int SAVETIME_TYPE = 4;
    public static final int APPLICATION_TYPE = 6;
    public static final int OPERATOR_TYPE = 7;
    public static final int HOST_TYPE = 8;
    public static final int FILE_NAME_TYPE = 9;
    public static final int FILE_DESCRIPTION_TYPE = 10;
    public static final int LAST_STANDARD_HEADER_FIELD = 10;
    private static final byte[] PWS3_FILEID = new byte[]{80, 87, 83, 51};
    private static final byte[] V3VERSION = new byte[]{2, 3};
    private byte[] tag = new byte[4];
    private byte[] salt = new byte[32];
    private int iter = 4096;
    private byte[] hpm = new byte[32];
    private byte[] b12 = new byte[32];
    private byte[] b34 = new byte[32];
    private byte[] iv = new byte[16];
    private HeaderFieldList hdrFields = new HeaderFieldList();
    private boolean isRead;
    private byte[] hseed;
    private boolean isVerified;
    private InputStream input;
    private BlockInputStream blockStream;
    private V3_InputStream v3In;
    private PwsChecksum writeHmac;
    private PwsChecksum readHmac;

    public PwsFileHeaderV3() {
        this((HeaderFieldList)null);
    }

    public PwsFileHeaderV3(HeaderFieldList headerFieldList) {
        Log.log(5, "(PwsFileHeaderV3) initializer (headerFields)");
        if (headerFieldList != null) {
            this.hdrFields = headerFieldList;
        }
        this.ensureHeaderDefaults();
    }

    private void ensureHeaderDefaults() {
        Log.log(5, "(PwsFileHeaderV3) ensureHeaderDefaults, 0");
        this.removeHeaderField(5);
        this.setHeaderField(new PwsRawField(0, V3VERSION));
        this.setHeaderField(PwsRawField.makeTextField(6, Global.getProgramName()));
        this.setHeaderField(PwsRawField.makeTextField(7, System.getProperty("user.name")));
        this.setHeaderField(PwsRawField.makeTextField(8, System.getProperty("os.name") + " " + System.getProperty("os.version")));
        PwsRawField pwsRawField = PwsRawField.makeTimeField(4, System.currentTimeMillis(), 4);
        this.setHeaderField(pwsRawField);
        if (this.getFileID() == null) {
            this.setHeaderField(new PwsRawField(1, new UUID().getBytes()));
        }
        Log.log(5, "(PwsFileHeaderV3) ensureHeaderDefaults, exit");
    }

    public PwsFileHeaderV3(InputStream inputStream) throws IOException, UnsupportedFileVersionException {
        this();
        this.input = inputStream;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(this.tag);
        if (!Util.equalArrays(this.tag, PWS3_FILEID)) {
            throw new UnsupportedFileVersionException();
        }
        dataInputStream.readFully(this.salt);
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        this.iter = Util.readIntLittle(byArray, 0);
        dataInputStream.readFully(this.hpm);
        dataInputStream.readFully(this.b12);
        dataInputStream.readFully(this.b34);
        dataInputStream.readFully(this.iv);
        this.isRead = true;
        Log.log(5, "(PwsFileHeaderV3) file header read: " + Util.bytesToHex(this.salt));
    }

    public void setIterations(int n) {
        if (n < 2048) {
            throw new IllegalArgumentException();
        }
        this.iter = n;
    }

    public PwsBlockInputStream getBlockStream() {
        return this.blockStream;
    }

    public int getIterations() {
        return this.iter;
    }

    public byte[] getHashSeed() {
        return this.hseed;
    }

    public byte[] getReadChecksum() {
        return this.v3In == null ? null : this.v3In.getHashMac();
    }

    public UUID getFileID() {
        PwsRawField pwsRawField = this.hdrFields.getField(1);
        return pwsRawField == null ? null : new UUID(pwsRawField.getData());
    }

    public HeaderFieldList getHeaderFields() {
        return this.hdrFields;
    }

    public void setHeaderField(PwsRawField pwsRawField) {
        this.hdrFields.setField(pwsRawField);
    }

    public PwsRawField getHeaderField(int n) {
        return this.hdrFields.getField(n);
    }

    public PwsRawField removeHeaderField(int n) {
        return this.hdrFields.removeField(n);
    }

    public PwsCipher save(OutputStream outputStream, PwsPassphrase pwsPassphrase) throws IOException {
        Log.log(5, "(PwsFileHeaderV3) save");
        OutputStream outputStream2 = outputStream;
        PwsCipher pwsCipher = this.update(pwsPassphrase);
        this.writeHmac = new PwsChecksum(this.hseed);
        this.ensureHeaderDefaults();
        outputStream2.write(PWS3_FILEID);
        outputStream2.write(this.salt);
        byte[] byArray = new byte[4];
        Util.writeIntLittle(this.iter, byArray, 0);
        outputStream2.write(byArray);
        outputStream2.write(this.hpm);
        outputStream2.write(this.b12);
        outputStream2.write(this.b34);
        outputStream2.write(this.iv);
        Iterator iterator = this.hdrFields.iterator();
        while (iterator.hasNext()) {
            ((PwsRawField)iterator.next()).writeEncrypted(outputStream2, pwsCipher, 3, this.writeHmac);
        }
        new PwsRawField(255, null).writeEncrypted(outputStream2, pwsCipher, 3);
        Log.log(5, "(PwsFileHeaderV3) file header saved: " + Util.bytesToHex(this.salt));
        return pwsCipher;
    }

    public PwsChecksum getWriteHmac() {
        return this.writeHmac;
    }

    public PwsChecksum getReadHmac() {
        return this.readHmac;
    }

    private PwsCipher update(PwsPassphrase pwsPassphrase) {
        if (pwsPassphrase == null) {
            throw new NullPointerException("passphrase missing");
        }
        this.isRead = false;
        CryptoRandom cryptoRandom = Util.getCryptoRand();
        this.salt = cryptoRandom.nextBytes(this.salt.length);
        this.iv = cryptoRandom.nextBytes(this.iv.length);
        byte[] byArray = cryptoRandom.nextBytes(32);
        this.hseed = cryptoRandom.nextBytes(32);
        byte[] byArray2 = PwsFileHeaderV3.makeInternalKey(pwsPassphrase, this.salt, this.iter);
        this.hpm = PwsFileHeaderV3.genRandHash(byArray2);
        TwofishCipher twofishCipher = new TwofishCipher(byArray2);
        this.b12 = twofishCipher.encrypt(byArray);
        this.b34 = twofishCipher.encrypt(this.hseed);
        this.isRead = true;
        TwofishCipher twofishCipher2 = new TwofishCipher(byArray, this.iv);
        Util.destroyBytes(byArray);
        Util.destroyBytes(byArray2);
        return twofishCipher2;
    }

    public PwsBlockInputStream verifyPass(PwsPassphrase pwsPassphrase) throws IOException {
        if (pwsPassphrase == null) {
            throw new NullPointerException("passphrase missing");
        }
        if (!this.isRead) {
            throw new IllegalStateException("header not initialized");
        }
        if (this.isVerified) {
            throw new IllegalStateException("duplicate header verification");
        }
        byte[] byArray = PwsFileHeaderV3.makeInternalKey(pwsPassphrase, this.salt, this.iter);
        byte[] byArray2 = PwsFileHeaderV3.genRandHash(byArray);
        if (Util.equalArrays(byArray2, this.hpm)) {
            TwofishCipher twofishCipher = new TwofishCipher(byArray);
            byte[] byArray3 = twofishCipher.decrypt(this.b12);
            this.hseed = twofishCipher.decrypt(this.b34);
            this.readHmac = new PwsChecksum(this.hseed);
            TwofishCipher twofishCipher2 = new TwofishCipher(byArray3, this.iv);
            Util.destroyBytes(byArray3);
            this.v3In = new V3_InputStream(this.input);
            this.blockStream = new BlockInputStream(this.v3In, twofishCipher2);
            while (true) {
                byte[] byArray4;
                if ((byArray4 = this.blockStream.peekBlock())[4] == -1) break;
                PwsRawField pwsRawField = new PwsRawField(this.blockStream, 3);
                Log.log(5, "** read HEADER FIELD: t=" + pwsRawField.getType() + ", c=" + Util.bytesToHex(pwsRawField.getData()));
                Log.log(5, "                            " + Util.printableString(pwsRawField.getString("UTF-8")));
                this.setHeaderField(pwsRawField);
                this.readHmac.update(pwsRawField.getData());
            }
            this.blockStream.readBlock();
            this.isVerified = true;
            this.blockStream.resetCounter();
            return this.blockStream;
        }
        return null;
    }

    private static byte[] makeInternalKey(PwsPassphrase pwsPassphrase, byte[] byArray, int n) {
        SHA256 sHA256 = new SHA256();
        byte[] byArray2 = pwsPassphrase.getBytes(null);
        sHA256.update(byArray2);
        Util.destroyBytes(byArray2);
        sHA256.update(byArray);
        byte[] byArray3 = sHA256.digest();
        for (int i = 0; i < n; ++i) {
            sHA256.reset();
            sHA256.update(byArray3);
            byArray3 = sHA256.digest();
        }
        return byArray3;
    }

    private static byte[] genRandHash(byte[] byArray) {
        SHA256 sHA256 = new SHA256();
        sHA256.update(byArray);
        byte[] byArray2 = sHA256.digest();
        Log.debug(10, "(PwsFileHeaderV3) producing a key validator hash =" + Util.bytesToHex(byArray2));
        return byArray2;
    }

    public static byte[] genRandHash(PwsPassphrase pwsPassphrase, byte[] byArray, int n) {
        byte[] byArray2 = PwsFileHeaderV3.makeInternalKey(pwsPassphrase, byArray, n);
        return PwsFileHeaderV3.genRandHash(byArray2);
    }
}

