/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.data.HeaderFieldList;
import org.jpws.pwslib.data.PwsBlockInputStream;
import org.jpws.pwslib.data.PwsFileHeaderV1;
import org.jpws.pwslib.data.PwsFileHeaderV2;
import org.jpws.pwslib.data.PwsFileHeaderV3;
import org.jpws.pwslib.data.PwsPassphrase;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.data.PwsRawFieldReader;
import org.jpws.pwslib.data.RawFieldReader;
import org.jpws.pwslib.exception.UnsupportedFileVersionException;
import org.jpws.pwslib.exception.WrongFileVersionException;
import org.jpws.pwslib.global.PwsChecksum;
import org.jpws.pwslib.global.UUID;

public class PwsFileInputSocket {
    private static final int MAX_READ_AHEAD = 32000;
    private boolean isOpen;
    private int fversion;
    private String options = "";
    private BufferedInputStream in;
    private PwsCipher cipher;
    private PwsBlockInputStream blockStream;
    private PwsBlockInputStream userStream;
    private HeaderFieldList headerFields;
    private PwsFileHeaderV3 headerV3;
    private PwsChecksum hmac;

    public PwsFileInputSocket(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("input == null");
        }
        this.in = new BufferedInputStream(inputStream);
        this.in.mark(32000);
    }

    public boolean attemptOpen(PwsPassphrase pwsPassphrase) throws IOException {
        try {
            return this.attemptOpen(pwsPassphrase, 0);
        }
        catch (WrongFileVersionException wrongFileVersionException) {
            return false;
        }
        catch (UnsupportedFileVersionException unsupportedFileVersionException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attemptOpen(PwsPassphrase pwsPassphrase, int n) throws IOException, WrongFileVersionException, UnsupportedFileVersionException {
        boolean bl;
        block7: {
            block6: {
                if (this.isOpen) {
                    throw new IllegalStateException("socket is already open");
                }
                bl = n == 0;
                this.in.reset();
                if (!(bl | n == 3) || !this.openV3(pwsPassphrase, bl)) break block6;
                this.in.mark(0);
                boolean bl2 = true;
                return bl2;
            }
            this.in.reset();
            if (!(bl | n == 2) || !this.openV2(pwsPassphrase, bl)) break block7;
            this.in.mark(0);
            boolean bl3 = true;
            return bl3;
        }
        this.in.reset();
        if (bl | n == 1 && this.openV1(pwsPassphrase, bl)) {
            this.in.mark(0);
            boolean bl4 = true;
            return bl4;
        }
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private boolean openV1(PwsPassphrase pwsPassphrase, boolean bl) throws IOException, WrongFileVersionException {
        PwsFileHeaderV1 pwsFileHeaderV1 = new PwsFileHeaderV1(this.in);
        try {
            this.blockStream = pwsFileHeaderV1.verifyPass(pwsPassphrase);
            if (this.blockStream == null) {
                return false;
            }
        }
        catch (WrongFileVersionException wrongFileVersionException) {
            if (bl) {
                return false;
            }
            throw wrongFileVersionException;
        }
        this.in.mark(2048);
        this.fversion = 1;
        this.isOpen = true;
        return true;
    }

    private boolean openV2(PwsPassphrase pwsPassphrase, boolean bl) throws IOException, WrongFileVersionException {
        PwsFileHeaderV2 pwsFileHeaderV2 = new PwsFileHeaderV2(this.in);
        try {
            this.blockStream = pwsFileHeaderV2.verifyPass(pwsPassphrase);
            if (this.blockStream == null) {
                return false;
            }
        }
        catch (WrongFileVersionException wrongFileVersionException) {
            if (bl) {
                return false;
            }
            throw wrongFileVersionException;
        }
        this.in.mark(2048);
        this.options = pwsFileHeaderV2.getOptions();
        this.fversion = 2;
        this.isOpen = true;
        return true;
    }

    private boolean openV3(PwsPassphrase pwsPassphrase, boolean bl) throws IOException, UnsupportedFileVersionException {
        try {
            this.headerV3 = new PwsFileHeaderV3(this.in);
            this.blockStream = this.headerV3.verifyPass(pwsPassphrase);
            if (this.blockStream == null) {
                return false;
            }
        }
        catch (UnsupportedFileVersionException unsupportedFileVersionException) {
            if (bl) {
                return false;
            }
            throw unsupportedFileVersionException;
        }
        this.in.mark(2048);
        this.headerFields = this.headerV3.getHeaderFields();
        this.hmac = this.headerV3.getReadHmac();
        this.options = this.headerFields.getStringValue(64);
        this.fversion = 3;
        this.isOpen = true;
        return true;
    }

    public int getFileVersion() {
        return this.fversion;
    }

    public int getBlocksize() {
        return this.cipher != null ? this.cipher.getBlockSize() : 0;
    }

    public PwsRawFieldReader getRawFieldReader() throws IOException {
        PwsBlockInputStream pwsBlockInputStream = this.getBlockInputStream();
        return new RawFieldReader(pwsBlockInputStream, this.fversion, this.hmac);
    }

    public PwsBlockInputStream getBlockInputStream() throws IOException {
        if (!this.isOpen) {
            throw new IllegalStateException("socket not open");
        }
        if (this.userStream != null) {
            throw new IllegalStateException("input stream in use or consumed");
        }
        this.userStream = this.blockStream;
        return this.userStream;
    }

    public String getOptions() {
        return this.options;
    }

    public byte[] getReadChecksum() {
        return this.headerV3 == null ? null : this.headerV3.getReadChecksum();
    }

    public int getIterations() {
        return this.headerV3 == null ? 0 : this.headerV3.getIterations();
    }

    public byte[] getCalcChecksum() {
        return this.hmac == null ? null : this.hmac.digest();
    }

    public HeaderFieldList getHeaderFields() {
        return this.headerFields;
    }

    public UUID getFileUUID() {
        PwsRawField pwsRawField = this.headerFields != null ? this.headerFields.getField(1) : null;
        return pwsRawField == null ? null : new UUID(pwsRawField.getData());
    }
}

