/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jpws.pwslib.crypto.SHA256;
import org.jpws.pwslib.data.PwsFileEvent;
import org.jpws.pwslib.data.PwsFileListener;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.exception.DuplicateEntryException;
import org.jpws.pwslib.exception.NoSuchRecordException;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.global.UUID;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.order.OrderedRecordList;

public class PwsRecordList
implements Cloneable {
    public static final int MERGE_PLAIN = 0;
    public static final int MERGE_MODIFIED = 1;
    public static final int MERGE_PASSACCESSED = 2;
    public static final int MERGE_PASSMODIFIED = 4;
    public static final int MERGE_EXPIRY = 8;
    public static final int MERGE_INCLUDE = 16;
    private static int instanceCounter;
    protected int fileID;
    protected String idString;
    private UUID listUUID = new UUID();
    private TreeMap recMap = new TreeMap();
    private ArrayList listeners = new ArrayList();
    private boolean modified = true;
    protected boolean eventPause;

    public PwsRecordList() {
        this.initInstance();
    }

    public PwsRecordList(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        this.initInstance();
        if (defaultRecordWrapperArray != null) {
            for (int i = 0; i < defaultRecordWrapperArray.length; ++i) {
                try {
                    this.addReadRecord(defaultRecordWrapperArray[i].getRecord());
                    continue;
                }
                catch (DuplicateEntryException duplicateEntryException) {
                    // empty catch block
                }
            }
        }
    }

    private void initInstance() {
        this.fileID = instanceCounter++;
        this.idString = " (" + this.fileID + "): ";
        Log.log(2, "(PwsRecList) new PwsRecordList: ID = " + this.fileID);
    }

    public PwsRecord[] toArray() {
        PwsRecord[] pwsRecordArray = new PwsRecord[this.recMap.size()];
        Iterator iterator = this.recMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            pwsRecordArray[n] = (PwsRecord)((PwsRecord)iterator.next()).clone();
            ++n;
        }
        return pwsRecordArray;
    }

    public DefaultRecordWrapper[] toRecordWrappers(Locale locale) {
        return DefaultRecordWrapper.makeWrappers(this.toArray(), locale);
    }

    public void addRecord(PwsRecord pwsRecord) throws DuplicateEntryException {
        if (!pwsRecord.isValid()) {
            throw new IllegalArgumentException("invalid record: " + pwsRecord.getInvalidText() + " (cannot be added)");
        }
        this.addRecordIntern(pwsRecord, "(appl)");
    }

    void addReadRecord(PwsRecord pwsRecord) throws DuplicateEntryException {
        if (pwsRecord.getRecordID() == null) {
            throw new IllegalArgumentException("invalid record, cannot be added");
        }
        this.addRecordIntern(pwsRecord, "(read)");
    }

    private void addRecordIntern(PwsRecord pwsRecord, String string) throws DuplicateEntryException {
        if (this.contains(pwsRecord)) {
            throw new DuplicateEntryException("double record entry, cannot be added");
        }
        PwsRecord pwsRecord2 = (PwsRecord)pwsRecord.clone();
        this.recMap.put(pwsRecord2.getRecordID(), pwsRecord2);
        this.setModified();
        if (Log.getDebugLevel() > 2) {
            Log.debug(3, "(PwsRecList) record added to list " + string + this.idString + pwsRecord.toString() + ", entry no. " + (this.recMap.size() - 1) + ", crc=" + pwsRecord.getCRC());
        }
        this.fireFileEvent(1, (PwsRecord)pwsRecord2.clone());
    }

    public PwsRecordList addRecordList(PwsRecordList pwsRecordList) throws DuplicateEntryException {
        Iterator iterator = pwsRecordList.iterator();
        while (iterator.hasNext()) {
            if (((PwsRecord)iterator.next()).isValid()) continue;
            throw new IllegalArgumentException("list contains invalid record");
        }
        boolean bl = this.getEventPause();
        this.setEventPause(true);
        iterator = pwsRecordList.iterator();
        while (iterator.hasNext()) {
            this.addRecord((PwsRecord)iterator.next());
        }
        this.setEventPause(bl);
        return this;
    }

    public PwsRecordList removeRecordList(PwsRecordList pwsRecordList) {
        if (pwsRecordList != null) {
            boolean bl = this.getEventPause();
            this.setEventPause(true);
            Iterator iterator = pwsRecordList.iterator();
            while (iterator.hasNext()) {
                this.removeRecord((PwsRecord)iterator.next());
            }
            this.setEventPause(bl);
        }
        return this;
    }

    public PwsRecordList cutSetRecordList(PwsRecordList pwsRecordList) {
        PwsRecordList pwsRecordList2 = new PwsRecordList();
        Iterator iterator = pwsRecordList.iterator();
        while (iterator.hasNext()) {
            PwsRecord pwsRecord = (PwsRecord)iterator.next();
            PwsRecord pwsRecord2 = this.getRecord(pwsRecord.getRecordID());
            if (pwsRecord2 == null) continue;
            try {
                pwsRecordList2.addReadRecord(pwsRecord2);
            }
            catch (DuplicateEntryException duplicateEntryException) {}
        }
        return pwsRecordList2;
    }

    public PwsRecordList updateRecordList(PwsRecordList pwsRecordList) {
        PwsRecordList pwsRecordList2 = null;
        boolean bl = this.getEventPause();
        this.setEventPause(true);
        Iterator iterator = pwsRecordList.iterator();
        while (iterator.hasNext()) {
            PwsRecord pwsRecord = (PwsRecord)iterator.next();
            try {
                this.updateRecord(pwsRecord);
            }
            catch (NoSuchRecordException noSuchRecordException) {
                if (pwsRecordList2 == null) {
                    pwsRecordList2 = new PwsRecordList();
                }
                try {
                    pwsRecordList2.addReadRecord(pwsRecord);
                }
                catch (DuplicateEntryException duplicateEntryException) {
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (pwsRecordList2 == null) {
                    pwsRecordList2 = new PwsRecordList();
                }
                try {
                    pwsRecordList2.addReadRecord(pwsRecord);
                }
                catch (DuplicateEntryException duplicateEntryException) {}
            }
        }
        this.setEventPause(bl);
        return pwsRecordList2;
    }

    public void updateRecord(PwsRecord pwsRecord) throws NoSuchRecordException {
        if (!pwsRecord.isValid()) {
            throw new IllegalArgumentException("invalid record, cannot be updated");
        }
        if (!this.contains(pwsRecord)) {
            throw new NoSuchRecordException("failed update on record " + pwsRecord);
        }
        PwsRecord pwsRecord2 = this.getRecordIntern(pwsRecord.getRecordID());
        int n = pwsRecord2.getCRC();
        if (n != pwsRecord.getCRC()) {
            PwsRecord pwsRecord3 = (PwsRecord)pwsRecord.clone();
            this.recMap.remove(pwsRecord.getRecordID());
            this.recMap.put(pwsRecord.getRecordID(), pwsRecord3);
            this.setModified();
            if (Log.getDebugLevel() > 2) {
                Log.debug(3, "record updated in file" + this.idString + pwsRecord3);
            }
            this.fireFileEvent(3, (PwsRecord)pwsRecord3.clone());
        }
    }

    public int getRecordCount() {
        return this.recMap.size();
    }

    public Iterator iterator() {
        return new FileIterator(((Map)this.recMap.clone()).values().iterator());
    }

    public long getUnknownFieldSize(int n) {
        Iterator iterator = this.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            l += ((PwsRecord)iterator.next()).getUnknownFieldSize(n);
        }
        return l;
    }

    public int getUnknownFieldCount() {
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            n += ((PwsRecord)iterator.next()).getUnknownFieldCount();
        }
        return n;
    }

    public void clearUnknownFields() {
        if (this.getUnknownFieldCount() > 0) {
            PwsRecordList pwsRecordList = new PwsRecordList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                PwsRecord pwsRecord = (PwsRecord)iterator.next();
                if (pwsRecord.getUnknownFieldCount() <= 0) continue;
                pwsRecord.clearExtraFields();
                try {
                    pwsRecordList.addReadRecord(pwsRecord);
                }
                catch (DuplicateEntryException duplicateEntryException) {}
            }
            this.updateRecordList(pwsRecordList);
            Log.log(3, "cleared unknown fields in reclist" + this.idString);
        }
    }

    public int getGrpRecordCount(String string, boolean bl) {
        if (string == null) {
            return 0;
        }
        if (string.length() == 0) {
            return this.getRecordCount();
        }
        return new GroupFileIterator(string, bl).grpList.size();
    }

    public Iterator getGroupedRecords(String string, boolean bl) {
        return new GroupFileIterator(string, bl);
    }

    public int countExpired(long l) {
        int n = 0;
        Iterator iterator = this.recMap.values().iterator();
        while (iterator.hasNext()) {
            if (!((PwsRecord)iterator.next()).willExpire(l)) continue;
            ++n;
        }
        return n;
    }

    public PwsRecordList renameGroup(String string, String string2) {
        boolean bl = this.getEventPause();
        this.setEventPause(true);
        PwsRecordList pwsRecordList = new PwsRecordList();
        Iterator iterator = this.getGroupedRecords(string, true);
        while (iterator.hasNext()) {
            PwsRecord pwsRecord = (PwsRecord)iterator.next();
            String string3 = pwsRecord.getGroup();
            String string4 = string2;
            if (string3.length() > string.length()) {
                string4 = string4 + string3.substring(string.length());
            }
            pwsRecord.setGroup(string4);
            try {
                this.updateRecord(pwsRecord);
                try {
                    pwsRecordList.addRecordIntern(pwsRecord, "* internal rename group *");
                }
                catch (Exception exception) {}
            }
            catch (NoSuchRecordException noSuchRecordException) {
                throw new IllegalStateException("PWSLIB renameGroup():\r\n" + noSuchRecordException);
            }
        }
        this.setEventPause(bl);
        return pwsRecordList;
    }

    public void removeGroup(String string) {
        Iterator iterator = this.getGroupedRecords(string, true);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public List getGroupList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        OrderedRecordList orderedRecordList = new OrderedRecordList(this);
        orderedRecordList.loadDatabase(this, 0L);
        for (int i = 0; i < orderedRecordList.size(); ++i) {
            String string = orderedRecordList.getItemAt(i).getRecord().getGroup();
            if (string == null || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        this.removeFileListener(orderedRecordList);
        return arrayList;
    }

    public int getGroupCount() {
        HashMap hashMap = new HashMap(Math.max(this.getRecordCount(), 32));
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            String string = ((PwsRecord)iterator.next()).getGroup();
            if (string == null) continue;
            hashMap.put(string, null);
        }
        return hashMap.size();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void removeRecord(PwsRecord pwsRecord) {
        if (this.contains(pwsRecord)) {
            this.recMap.remove(pwsRecord.getRecordID());
            this.setModified();
            if (Log.getDebugLevel() > 2) {
                Log.debug(3, "record removed from list" + this.idString + pwsRecord.toString());
            }
            this.fireFileEvent(2, pwsRecord);
        }
    }

    public void removeRecord(UUID uUID) {
        PwsRecord pwsRecord = this.getRecordIntern(uUID);
        if (pwsRecord != null) {
            this.removeRecord(pwsRecord);
        }
    }

    public boolean contains(PwsRecord pwsRecord) {
        return pwsRecord == null ? false : this.recMap.containsKey(pwsRecord.getRecordID());
    }

    public boolean contains(UUID uUID) {
        return uUID == null ? false : this.recMap.containsKey(uUID);
    }

    public boolean containsGroup(String string) {
        int n = string.length();
        Iterator iterator = this.recMap.values().iterator();
        while (iterator.hasNext()) {
            String string2 = ((PwsRecord)iterator.next()).getGroup();
            if (string2 == null || !string2.startsWith(string) || string2.length() != n && string2.charAt(n) != '.') continue;
            return true;
        }
        return false;
    }

    protected PwsRecord getRecordIntern(UUID uUID) {
        return uUID == null ? null : (PwsRecord)this.recMap.get(uUID);
    }

    public PwsRecord getRecord(UUID uUID) {
        PwsRecord pwsRecord = this.getRecordIntern(uUID);
        if (pwsRecord != null) {
            pwsRecord = (PwsRecord)pwsRecord.clone();
        }
        return pwsRecord;
    }

    public long getBlockedDataSize(int n, String string) {
        long l = 0L;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            l += ((PwsRecord)iterator.next()).getBlockedDataSize(n, string);
        }
        return l;
    }

    public byte[] getSignature() {
        SHA256 sHA256 = new SHA256();
        Iterator iterator = this.recMap.values().iterator();
        while (iterator.hasNext()) {
            sHA256.update(((PwsRecord)iterator.next()).getSignature());
        }
        return sHA256.digest();
    }

    public void clear() {
        int n = this.getRecordCount();
        if (n > 0) {
            this.recMap.clear();
            this.setModified();
            Log.debug(3, "clear, all records removed in list" + this.idString + n);
            this.fireFileEvent(4, null);
        }
    }

    public Object clone() {
        PwsRecordList pwsRecordList;
        try {
            pwsRecordList = (PwsRecordList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        pwsRecordList.recMap = (TreeMap)this.recMap.clone();
        pwsRecordList.listeners = new ArrayList();
        pwsRecordList.fileID = instanceCounter++;
        pwsRecordList.idString = " (" + pwsRecordList.fileID + "): ";
        pwsRecordList.modified = true;
        Log.log(2, "(PwsRecList) new PwsRecordList (clone of " + this.idString + "): ID = " + pwsRecordList.fileID);
        return pwsRecordList;
    }

    public Object copy() {
        PwsRecordList pwsRecordList = (PwsRecordList)this.clone();
        try {
            pwsRecordList.clear();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                pwsRecordList.addReadRecord((PwsRecord)iterator.next());
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("list copy error: " + exception.getMessage());
        }
        Log.log(2, "(PwsRecList) create copy of PwsRecordList " + this.idString + ": ID = " + pwsRecordList.fileID);
        return pwsRecordList;
    }

    protected void setModified() {
        this.modified = true;
    }

    public void resetModified() {
        this.modified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileListener(PwsFileListener pwsFileListener) {
        if (pwsFileListener != null && !this.listeners.contains(pwsFileListener)) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.add(pwsFileListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileListener(PwsFileListener pwsFileListener) {
        if (pwsFileListener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(pwsFileListener);
            }
        }
    }

    protected void fireFileEvent(int n, PwsRecord pwsRecord) {
        int n2;
        if (!this.eventPause && (n2 = this.listeners.size()) > 0) {
            PwsFileEvent pwsFileEvent = new PwsFileEvent(this, n, pwsRecord);
            for (int i = 0; i < n2; ++i) {
                ((PwsFileListener)this.listeners.get(i)).fileStateChanged(pwsFileEvent);
            }
        }
    }

    protected void contentModified() {
        this.setModified();
        this.fireFileEvent(8, null);
    }

    public void setEventPause(boolean bl) {
        boolean bl2 = this.eventPause;
        this.eventPause = bl;
        if (bl2 & !this.eventPause) {
            this.fireFileEvent(9, null);
        }
    }

    public boolean getEventPause() {
        return this.eventPause;
    }

    public DefaultRecordWrapper[] moveRecords(DefaultRecordWrapper[] defaultRecordWrapperArray, String string, boolean bl) {
        if (defaultRecordWrapperArray != null && defaultRecordWrapperArray.length > 0) {
            PwsRecordList pwsRecordList = new PwsRecordList();
            for (int i = 0; i < defaultRecordWrapperArray.length; ++i) {
                PwsRecord pwsRecord = defaultRecordWrapperArray[i].getRecord();
                PwsRecord pwsRecord2 = this.getRecord(pwsRecord.getRecordID());
                if (pwsRecord2 == null) continue;
                String string2 = pwsRecord2.getGroup();
                string2 = bl && string2 != null ? string + "." + string2 : string;
                pwsRecord2.setGroup(string2);
                pwsRecord.setGroup(string2);
                try {
                    pwsRecordList.addRecord(pwsRecord2);
                    continue;
                }
                catch (DuplicateEntryException duplicateEntryException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            PwsRecordList pwsRecordList2 = this.updateRecordList(pwsRecordList);
            if (pwsRecordList2 != null) {
                pwsRecordList.removeRecordList(pwsRecordList2);
            }
            return pwsRecordList.toRecordWrappers(null);
        }
        return null;
    }

    public synchronized PwsRecordList merge(PwsRecordList pwsRecordList, int n) {
        boolean bl = n == 0;
        boolean bl2 = (n & 1) == 1;
        boolean bl3 = (n & 8) == 8;
        boolean bl4 = (n & 4) == 4;
        boolean bl5 = (n & 2) == 2;
        PwsRecordList pwsRecordList2 = new PwsRecordList();
        boolean bl6 = this.getEventPause();
        this.setEventPause(true);
        Iterator iterator = pwsRecordList.iterator();
        while (iterator.hasNext()) {
            PwsRecord pwsRecord = (PwsRecord)iterator.next();
            if (this.contains(pwsRecord)) {
                PwsRecord pwsRecord2 = this.getRecordIntern(pwsRecord.getRecordID());
                boolean bl7 = false;
                try {
                    if (bl || bl2 && pwsRecord.getModifiedTime() <= pwsRecord2.getModifiedTime() || bl4 && pwsRecord.getPassModTime() <= pwsRecord2.getPassModTime() || bl5 && pwsRecord.getAccessTime() <= pwsRecord2.getAccessTime() || bl3 && pwsRecord.getPassLifeTime() <= pwsRecord2.getPassLifeTime()) {
                        bl7 = true;
                        pwsRecordList2.addReadRecord(pwsRecord);
                        continue;
                    }
                    pwsRecord.setImportStatus(2);
                    this.updateRecord(pwsRecord);
                }
                catch (Exception exception) {
                    System.out.println("*** Failed Merge Record " + (bl7 ? "(exclude-list): " : "(include-list): ") + pwsRecord.toString() + "  " + pwsRecord.getTitle());
                    System.out.println(exception);
                }
                continue;
            }
            try {
                pwsRecord.setImportStatus(1);
                this.addRecord(pwsRecord);
            }
            catch (Exception exception) {
                try {
                    pwsRecordList2.addReadRecord(pwsRecord);
                }
                catch (Exception exception2) {
                    System.out.println("*** Serious Record Failure (merge): " + pwsRecord.toString() + "  " + pwsRecord.getTitle());
                    System.out.println(exception2);
                }
            }
        }
        this.setEventPause(bl6);
        return pwsRecordList2;
    }

    public UUID getUUID() {
        return this.listUUID;
    }

    public void setUUID(UUID uUID) {
        if (uUID == null) {
            throw new NullPointerException();
        }
        this.listUUID = uUID;
        this.contentModified();
        Log.log(7, "(PwsRecordList) set UUID to : " + uUID);
    }

    private class GroupFileIterator
    implements Iterator {
        private List grpList = new ArrayList();
        private Iterator iter;
        private PwsRecord next;

        public GroupFileIterator(String string, boolean bl) {
            if (string != null) {
                int n = string.length();
                boolean bl2 = n == 0;
                Iterator iterator = PwsRecordList.this.iterator();
                while (iterator.hasNext()) {
                    PwsRecord pwsRecord = (PwsRecord)iterator.next();
                    if (bl2) {
                        this.grpList.add(pwsRecord);
                        continue;
                    }
                    String string2 = pwsRecord.getGroup();
                    if (string2 == null || !string2.startsWith(string) || bl && string2.length() != n && string2.charAt(n) != '.') continue;
                    this.grpList.add(pwsRecord);
                }
            }
            this.iter = this.grpList.iterator();
        }

        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        public final Object next() {
            this.next = (PwsRecord)this.iter.next();
            return (PwsRecord)this.next.clone();
        }

        public final void remove() {
            this.iter.remove();
            if (this.next != null) {
                PwsRecordList.this.removeRecord(this.next);
            }
        }
    }

    private class FileIterator
    implements Iterator {
        private Iterator iter;
        private PwsRecord record;

        public FileIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        public final Object next() {
            this.record = (PwsRecord)this.iter.next();
            return this.record.clone();
        }

        public final void remove() {
            if (this.record != null) {
                PwsRecordList.this.removeRecord(this.record);
                PwsRecordList.this.setModified();
            }
        }
    }
}

