/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.jpws.pwslib.crypto.PwsCipher;
import org.jpws.pwslib.data.BlockInputStream;
import org.jpws.pwslib.data.FieldHeader;
import org.jpws.pwslib.data.PwsBlockInputStream;
import org.jpws.pwslib.data.PwsRawField;
import org.jpws.pwslib.data.PwsRawFieldReader;
import org.jpws.pwslib.global.PwsChecksum;
import org.jpws.pwslib.global.Util;
import org.jpws.pwslib.persist.ByteArrayOutputStreamPws;

class RawFieldReader
implements PwsRawFieldReader {
    private PwsBlockInputStream blockStream;
    private PwsRawField nextField;
    private PwsChecksum hmac;
    private int blocksize;
    private int fileVersion;
    public static int rawCount;

    public RawFieldReader(PwsBlockInputStream pwsBlockInputStream, int n, PwsChecksum pwsChecksum) throws IOException {
        this.init(pwsBlockInputStream, n, pwsChecksum);
    }

    public RawFieldReader(InputStream inputStream, PwsCipher pwsCipher, int n, PwsChecksum pwsChecksum) throws IOException {
        this.blockStream = new BlockInputStream(inputStream, pwsCipher);
        this.init(this.blockStream, n, pwsChecksum);
    }

    private void init(PwsBlockInputStream pwsBlockInputStream, int n, PwsChecksum pwsChecksum) throws IOException {
        this.blockStream = pwsBlockInputStream;
        this.blocksize = this.blockStream.getBlockSize();
        this.fileVersion = n;
        this.hmac = pwsChecksum;
        this.readNextRawField();
    }

    public int getBlocksize() {
        return this.blocksize;
    }

    public void close() {
        this.nextField = null;
        this.blockStream = null;
    }

    public boolean hasNext() {
        return this.nextField != null;
    }

    public Object next() {
        PwsRawField pwsRawField = this.nextField;
        if (pwsRawField != null) {
            try {
                this.readNextRawField();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalStateException("Exception: " + exception);
            }
            return pwsRawField;
        }
        this.close();
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void readNextRawField() throws IOException {
        byte[] byArray;
        this.nextField = null;
        if (!this.blockStream.isAvailable()) {
            return;
        }
        FieldHeader fieldHeader = new FieldHeader(this.blockStream.readBlock(), this.fileVersion);
        ByteArrayOutputStreamPws byteArrayOutputStreamPws = new ByteArrayOutputStreamPws();
        if (fieldHeader.data != null) {
            byteArrayOutputStreamPws.write(fieldHeader.data);
        }
        if ((byArray = this.blockStream.readBlocks(fieldHeader.blocks)) == null) {
            throw new EOFException();
        }
        byteArrayOutputStreamPws.write(byArray);
        Util.destroyBytes(byArray);
        byte[] byArray2 = byteArrayOutputStreamPws.toByteArray();
        PwsRawField pwsRawField = new PwsRawField(fieldHeader.type, fieldHeader.length, byArray2);
        byteArrayOutputStreamPws.clear();
        fieldHeader.clear();
        Util.destroyBytes(byArray2);
        if (this.hmac != null) {
            this.hmac.update(pwsRawField.getData());
        }
        this.nextField = pwsRawField;
        ++rawCount;
    }
}

