/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.global;

import org.jpws.pwslib.crypto.SHA256;
import org.jpws.pwslib.global.Util;

public class PwsChecksum {
    private SHA256 sha = new SHA256();
    private byte[] opad;
    private byte[] digest;

    public PwsChecksum(byte[] byArray) {
        int n = this.sha.getBlockSize();
        if (byArray.length > n) {
            throw new IllegalArgumentException("seed length exceeding");
        }
        byte[] byArray2 = new byte[n];
        this.opad = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = 54;
            this.opad[i] = 92;
        }
        byte[] byArray3 = Util.arraycopy(byArray, n);
        byArray2 = Util.XOR_buffers(byArray2, byArray3);
        this.opad = Util.XOR_buffers(this.opad, byArray3);
        this.sha.update(byArray2);
    }

    public void update(byte[] byArray) {
        if (byArray != null) {
            this.sha.update(byArray);
        }
    }

    public byte[] digest() {
        if (this.digest == null) {
            byte[] byArray = this.sha.digest();
            this.sha.reset();
            this.sha.update(this.opad);
            this.sha.update(byArray);
            this.digest = this.sha.digest();
        }
        return this.digest;
    }
}

