/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.global;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import org.jpws.pwslib.crypto.SHA1;
import org.jpws.pwslib.global.Util;

public final class UUID
implements Cloneable,
Comparable {
    private final byte[] uidValue = new byte[16];

    public UUID() {
        SHA1 sHA1 = new SHA1();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            long l = System.currentTimeMillis();
            dataOutputStream.writeLong(l);
            for (int i = 0; i < 8; ++i) {
                dataOutputStream.writeByte(Util.nextRandByte());
            }
            dataOutputStream.close();
            sHA1.update(byteArrayOutputStream.toByteArray());
            sHA1.finalize();
            byte[] byArray = sHA1.getDigest();
            System.arraycopy(byArray, 0, this.uidValue, 0, this.uidValue.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("corrupted UUID creation");
        }
    }

    public UUID(byte[] byArray) {
        if (byArray == null || byArray.length != this.uidValue.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(byArray, 0, this.uidValue, 0, this.uidValue.length);
    }

    public UUID(String string) {
        byte[] byArray = Util.hexToBytes(string);
        if (byArray == null || byArray.length != this.uidValue.length) {
            throw new IllegalArgumentException("illegal UUID string: " + string);
        }
        System.arraycopy(byArray, 0, this.uidValue, 0, this.uidValue.length);
    }

    public boolean equals(Object object) {
        byte[] byArray = this.uidValue;
        byte[] byArray2 = ((UUID)object).uidValue;
        return Util.equalArrays(byArray, byArray2);
    }

    public int hashCode() {
        return Util.arrayHashcode(this.uidValue);
    }

    public int compareTo(Object object) {
        int n;
        UUID uUID = (UUID)object;
        for (n = 0; n < this.uidValue.length && this.uidValue[n] == uUID.uidValue[n]; ++n) {
        }
        if (n == this.uidValue.length) {
            return 0;
        }
        return this.uidValue[n] - uUID.uidValue[n];
    }

    public byte[] getBytes() {
        return (byte[])this.uidValue.clone();
    }

    public String toHexString() {
        return Util.bytesToHex(this.uidValue);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return UUID.toString(this.uidValue);
    }

    public static String toString(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Util.bytesToHex(byArray, 0, 4));
        stringBuffer.append('-');
        stringBuffer.append(Util.bytesToHex(byArray, 4, 2));
        stringBuffer.append('-');
        stringBuffer.append(Util.bytesToHex(byArray, 6, 2));
        stringBuffer.append('-');
        stringBuffer.append(Util.bytesToHex(byArray, 8, 2));
        stringBuffer.append('-');
        stringBuffer.append(Util.bytesToHex(byArray, 10, 6));
        return stringBuffer.toString();
    }
}

