/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.global;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormatSymbols;
import java.util.Random;
import org.jpws.pwslib.crypto.CryptoRandom;
import org.jpws.pwslib.crypto.SHA256;
import org.jpws.pwslib.global.Log;
import org.jpws.pwslib.order.DefaultRecordWrapper;

public class Util {
    private static CryptoRandom cryptoRand = new CryptoRandom();
    private static Random rand = new Random();

    public static CryptoRandom getCryptoRand() {
        return cryptoRand;
    }

    public static void setCryptoRandom(CryptoRandom cryptoRandom) {
        if (cryptoRandom != null) {
            cryptoRand = cryptoRandom;
        }
    }

    public static int nextRandByte() {
        return rand.nextInt(256);
    }

    public static int getRandom(int n) {
        return rand.nextInt(n);
    }

    public static byte[] randomBytes(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)Util.nextRandByte();
        }
        return byArray;
    }

    public static String bytesToHex(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "void";
        }
        int n3 = n + n2;
        if (n2 < 0 || n3 > byArray.length) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n3; ++i) {
            stringBuffer.append(Util.byteToHex(byArray[i]));
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static byte[] hexToBytes(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("hex string must be even");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() / 2);
        for (int i = 0; i < string.length(); i += 2) {
            int n = Integer.parseInt(string.substring(i, i + 2), 16);
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String bytesToHex(byte[] byArray) {
        if (byArray == null) {
            return "void";
        }
        return Util.bytesToHex(byArray, 0, byArray.length);
    }

    public static String byteToHex(int n) {
        String string = Integer.toString(n & 0xFF, 16);
        return string.length() == 1 ? "0" + string : string;
    }

    public static String shortToHex(int n) {
        String string = Integer.toString(n & 0xFFFF, 16);
        return "0000".substring(string.length()) + string;
    }

    public static String intToHex(long l) {
        String string = Long.toString(l & 0xFFFFFFFFL, 16);
        return "00000000".substring(string.length()) + string;
    }

    public static void writeLongLittle(long l, byte[] byArray, int n) {
        byArray[n] = (byte)l;
        byArray[n + 1] = (byte)(l >>> 8);
        byArray[n + 2] = (byte)(l >>> 16);
        byArray[n + 3] = (byte)(l >>> 24);
        byArray[n + 4] = (byte)(l >>> 32);
        byArray[n + 5] = (byte)(l >>> 40);
        byArray[n + 6] = (byte)(l >>> 48);
        byArray[n + 7] = (byte)(l >>> 56);
    }

    public static void writeIntLittle(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2 + 2] = (byte)(n >>> 16);
        byArray[n2 + 3] = (byte)(n >>> 24);
    }

    public static void writeInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static long readLongLittle(byte[] byArray, int n) {
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    public static int readIntLittle(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    public static long readUIntLittle(byte[] byArray, int n) {
        return (long)Util.readIntLittle(byArray, n) & 0xFFFFFFFFL;
    }

    public static void writeLong(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)(l >>> 0);
    }

    public static long readLong(byte[] byArray, int n) {
        return ((long)byArray[n + 7] & 0xFFL) << 56 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n] & 0xFFL) << 0;
    }

    public static byte[] getByteArray(char[] cArray) {
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            byArray[i * 2] = (byte)c;
            byArray[i * 2 + 1] = (byte)(c >>> 8);
        }
        return byArray;
    }

    public static void destroyBytes(byte[] byArray) {
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
        }
    }

    public static void destroyChars(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
    }

    public static boolean equalArrays(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalArrays(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2.length < byArray.length + n) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i + n]) continue;
            return false;
        }
        return true;
    }

    public static DefaultRecordWrapper[] cloneRecordWrappers(DefaultRecordWrapper[] defaultRecordWrapperArray) {
        DefaultRecordWrapper[] defaultRecordWrapperArray2 = new DefaultRecordWrapper[defaultRecordWrapperArray.length];
        for (int i = 0; i < defaultRecordWrapperArray.length; ++i) {
            defaultRecordWrapperArray2[i] = (DefaultRecordWrapper)defaultRecordWrapperArray[i].clone();
        }
        return defaultRecordWrapperArray2;
    }

    public static byte[] blockedBuffer(byte[] byArray, int n, int n2) {
        int n3 = byArray.length / n;
        if (byArray.length % n > 0) {
            ++n3;
        }
        n3 = Math.max(n2, n3);
        byte[] byArray2 = new byte[n3 * n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static byte[] arraycopy(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(n2, byArray.length - n));
        return byArray2;
    }

    public static byte[] arraycopy(byte[] byArray, int n) {
        return Util.arraycopy(byArray, 0, n);
    }

    public static byte[] arraycopy(byte[] byArray) {
        return Util.arraycopy(byArray, 0, byArray.length);
    }

    public static int arrayHashcode(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l += ((long)byArray[i] & 0xFFL) << i % 32;
        }
        return (int)l;
    }

    public static void transferData(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        Log.log(10, "(Util) data transfer start");
        while ((n2 = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
        Log.log(10, "(Util) data transfer end");
    }

    public static void bytesToLittleEndian(byte[] byArray) {
        if (byArray.length == 0 | byArray.length % 4 != 0) {
            throw new IllegalArgumentException("illegal buffer length");
        }
        for (int i = 0; i < byArray.length; i += 4) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 3];
            byArray[i + 3] = by;
            by = byArray[i + 1];
            byArray[i + 1] = byArray[i + 2];
            byArray[i + 2] = by;
        }
    }

    public static byte[] fingerPrint(byte[] byArray) {
        SHA256 sHA256 = new SHA256();
        sHA256.update(byArray);
        sHA256.finalize();
        return sHA256.digest();
    }

    public static String substituteText(String string, String string2, String string3) {
        int n;
        if (string == null | string2 == null | string3 == null || (n = string.indexOf(string2)) < 0) {
            return string;
        }
        while (n > -1) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
            n = string.indexOf(string2);
        }
        return string;
    }

    public static String substituteTextS(String string, String string2, String string3) {
        int n;
        if (string == null | string2 == null | string3 == null || string2.length() == 0 || (n = string.indexOf(string2)) < 0) {
            return string;
        }
        if (n > -1) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static final byte[] XOR_buffers(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            throw new IllegalArgumentException("buffer a,b length must be equal");
        }
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    public static String dottedNumber(long l) {
        String string = String.valueOf(l);
        String string2 = "";
        char c = new DecimalFormatSymbols().getGroupingSeparator();
        int n = string.length();
        while (n > 3) {
            string2 = c + string.substring(n - 3, n) + string2;
            string = string.substring(0, n - 3);
            n = string.length();
        }
        return string + string2;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static String printableString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) {
                c = '%';
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

