/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.order;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jpws.pwslib.data.PwsFile;
import org.jpws.pwslib.data.PwsFileEvent;
import org.jpws.pwslib.data.PwsFileListener;
import org.jpws.pwslib.data.PwsRecord;
import org.jpws.pwslib.data.PwsRecordList;
import org.jpws.pwslib.order.DefaultRecordWrapper;
import org.jpws.pwslib.order.OrderedListEvent;
import org.jpws.pwslib.order.OrderedListListener;

public class OrderedRecordList
implements PwsFileListener {
    protected PwsRecordList boundDbf;
    protected PwsRecordList loadedDbf;
    protected List list = new ArrayList();
    private Locale locale = Locale.getDefault();
    private List listeners = new ArrayList();
    private long expireScope;

    public OrderedRecordList() {
    }

    public OrderedRecordList(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public OrderedRecordList(PwsRecordList pwsRecordList) {
        if (pwsRecordList == null) {
            throw new IllegalArgumentException();
        }
        this.boundDbf = pwsRecordList;
    }

    public OrderedRecordList(PwsRecordList pwsRecordList, Locale locale) {
        if (pwsRecordList == null) {
            throw new IllegalArgumentException();
        }
        this.boundDbf = pwsRecordList;
        if (locale != null) {
            this.locale = locale;
        }
    }

    protected void clearBondage(PwsRecord pwsRecord) {
        if (this.boundDbf != null && !this.boundDbf.contains(pwsRecord)) {
            throw new IllegalArgumentException("unrelated record");
        }
    }

    public void insertItem(DefaultRecordWrapper defaultRecordWrapper) {
        DefaultRecordWrapper defaultRecordWrapper2 = defaultRecordWrapper;
        this.clearBondage(defaultRecordWrapper2.getRecord());
        this.insertRecordIntern(defaultRecordWrapper2);
        this.fireOrderedListEvent(1, defaultRecordWrapper2.getIndex(), defaultRecordWrapper2);
    }

    protected void insertRecordIntern(DefaultRecordWrapper defaultRecordWrapper) {
        int n = this.list.size();
        for (int i = 0; i < this.list.size(); ++i) {
            DefaultRecordWrapper defaultRecordWrapper2 = (DefaultRecordWrapper)this.list.get(i);
            if (defaultRecordWrapper.compareTo(defaultRecordWrapper2) >= 0) continue;
            n = i;
            break;
        }
        this.list.add(n, defaultRecordWrapper);
        defaultRecordWrapper.setIndex(n);
    }

    public void loadDatabase(PwsRecordList pwsRecordList, long l) {
        if (this.boundDbf != null && this.boundDbf instanceof PwsFile && !((PwsFile)this.boundDbf).equalResource((PwsFile)pwsRecordList)) {
            throw new IllegalArgumentException("unrelated database: " + ((PwsFile)pwsRecordList).getFilePath());
        }
        this.loadedDbf = pwsRecordList;
        this.expireScope = l;
        pwsRecordList.addFileListener(this);
        this.clear();
        Iterator iterator = pwsRecordList.iterator();
        while (iterator.hasNext()) {
            DefaultRecordWrapper defaultRecordWrapper = this.makeRecordWrapper((PwsRecord)iterator.next(), this.locale);
            this.insertRecordIntern(defaultRecordWrapper);
        }
        this.fireOrderedListEvent(4, -1, null);
    }

    public void reload() {
        if (this.loadedDbf != null) {
            this.loadDatabase(this.loadedDbf, this.expireScope);
        }
    }

    public DefaultRecordWrapper makeRecordWrapper(PwsRecord pwsRecord, Locale locale) {
        DefaultRecordWrapper defaultRecordWrapper = new DefaultRecordWrapper(pwsRecord, locale);
        if (this.expireScope > 0L) {
            defaultRecordWrapper.refreshExpiry(this.expireScope);
        }
        return defaultRecordWrapper;
    }

    public int size() {
        return this.list.size();
    }

    public DefaultRecordWrapper getItemAt(int n) {
        if (n > -1 && n < this.list.size()) {
            return (DefaultRecordWrapper)this.list.get(n);
        }
        return null;
    }

    public DefaultRecordWrapper[] getGroup(String string, boolean bl) {
        if (string == null) {
            return new DefaultRecordWrapper[0];
        }
        ArrayList<DefaultRecordWrapper> arrayList = new ArrayList<DefaultRecordWrapper>();
        int n = string.length();
        for (int i = 0; i < this.list.size(); ++i) {
            DefaultRecordWrapper defaultRecordWrapper = (DefaultRecordWrapper)this.list.get(i);
            String string2 = defaultRecordWrapper.getGroup();
            if (!string2.startsWith(string) || bl && string2.length() != n && string2.charAt(n) != '.') continue;
            arrayList.add(defaultRecordWrapper);
        }
        return arrayList.toArray(new DefaultRecordWrapper[0]);
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public int indexOf(PwsRecord pwsRecord) {
        return pwsRecord == null ? -1 : this.list.indexOf(this.makeRecordWrapper(pwsRecord, this.locale));
    }

    public int indexOf(DefaultRecordWrapper defaultRecordWrapper) {
        return defaultRecordWrapper == null ? -1 : this.list.indexOf(defaultRecordWrapper);
    }

    public void removeItem(int n) {
        if (n > -1 && n < this.list.size()) {
            DefaultRecordWrapper defaultRecordWrapper = (DefaultRecordWrapper)this.list.get(n);
            this.list.remove(n);
            this.fireOrderedListEvent(2, n, defaultRecordWrapper);
        }
    }

    public void clear() {
        if (this.size() > 0) {
            this.list.clear();
            this.fireOrderedListEvent(3, -1, null);
        }
    }

    public void setExpireScope(long l) {
        if (this.size() > 0) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                ((DefaultRecordWrapper)iterator.next()).refreshExpiry(l);
            }
            this.fireOrderedListEvent(4, -1, null);
        }
    }

    public void addOrderedListListener(OrderedListListener orderedListListener) {
        this.listeners.add(orderedListListener);
    }

    public void removeOrderedListListener(OrderedListListener orderedListListener) {
        this.listeners.remove(orderedListListener);
    }

    protected void fireOrderedListEvent(int n, int n2, DefaultRecordWrapper defaultRecordWrapper) {
        OrderedListEvent orderedListEvent = new OrderedListEvent(this, n, n2, defaultRecordWrapper);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((OrderedListListener)this.listeners.get(i)).orderedListPerformed(orderedListEvent);
        }
    }

    public void printout(PrintStream printStream) {
        printStream.println();
        String string = "- record list -";
        if (this.boundDbf != null && this.boundDbf instanceof PwsFile) {
            string = ((PwsFile)this.boundDbf).getFilePath();
        }
        printStream.println("+++ ORDERLIST PRINTOUT for DB : " + string);
        for (int i = 0; i < this.size(); ++i) {
            DefaultRecordWrapper defaultRecordWrapper = (DefaultRecordWrapper)this.list.get(i);
            PwsRecord pwsRecord = defaultRecordWrapper.getRecord();
            printStream.println("   - rec (" + i + ") " + defaultRecordWrapper.getSortValue() + ", " + pwsRecord.getRecordID());
        }
        printStream.println("#");
    }

    public void fileStateChanged(PwsFileEvent pwsFileEvent) {
        int n = pwsFileEvent.getType();
        PwsRecord pwsRecord = pwsFileEvent.getRecord();
        if (n == 1) {
            this.insertItem(this.makeRecordWrapper(pwsRecord, this.locale));
        } else if (n == 2) {
            int n2 = this.indexOf(pwsRecord);
            if (n2 > -1 && n2 < this.size()) {
                this.removeItem(n2);
            }
        } else if (n == 3) {
            int n3 = this.indexOf(pwsRecord);
            if (n3 > -1 && n3 < this.size()) {
                this.removeItem(n3);
                this.insertItem(this.makeRecordWrapper(pwsRecord, this.locale));
            }
        } else if (n == 9) {
            this.reload();
        } else if (n == 4) {
            this.clear();
        }
    }
}

