/*
 * Decompiled with CFR 0.152.
 */
package org.jpws.pwslib.persist;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jpws.pwslib.global.Global;
import org.jpws.pwslib.global.Util;

public class V3_InputStream
extends FilterInputStream {
    private byte[] hmac;
    private boolean eof;

    public V3_InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int available() throws IOException {
        return this.eof ? 0 : super.available();
    }

    public void close() throws IOException {
        super.close();
        this.eof = true;
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 % 16 > 0) {
            throw new IllegalArgumentException("illegal data block length, must be multiple of 16");
        }
        if (this.eof) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        for (int i = 0; i < n3; i += 16) {
            if (!Util.equalArrays(Global.FIELDSTREAM_ENDBLOCK_V3, byArray, n + i)) continue;
            byte[] byArray2 = new byte[32];
            int n4 = Math.min(n3 - i - 16, 32);
            System.arraycopy(byArray, n + i + 16, byArray2, 0, n4);
            if (super.read(byArray2, n4, 32 - n4) == 32 - n4) {
                this.hmac = byArray2;
            }
            n3 = i == 0 ? -1 : i;
            this.eof = true;
            break;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] getHashMac() {
        return this.hmac;
    }
}

